<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include 'head.php';
include 'header.php';
include 'sidebar.php';

if (!isset($_SESSION['userid'])) {
    header("Location: login.php");
    exit();
}

$feedback = "";

// Fetch current settings
$settings_res = $conn->query("SELECT promotion_fee FROM settings LIMIT 1");
$current_fee = ($settings_res && $settings_res->num_rows > 0) 
    ? $settings_res->fetch_assoc()['promotion_fee'] 
    : 0.00;

// Handle form submission (update promotion fee)
if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $promotion_fee = $_POST['promotion_fee'];

    if (!empty($promotion_fee) && is_numeric($promotion_fee)) {
        // If row exists update, else insert
        $stmt = $conn->prepare("INSERT INTO settings (id, promotion_fee) VALUES (1, ?) 
                                ON DUPLICATE KEY UPDATE promotion_fee = VALUES(promotion_fee)");
        $stmt->bind_param("d", $promotion_fee);

        if ($stmt->execute()) {
            $feedback = '<div class="alert alert-success">✅ Promotion fee updated successfully.</div>';
            $current_fee = $promotion_fee;
        } else {
            $feedback = '<div class="alert alert-danger">❌ Failed to update fee. Please try again.</div>';
        }
    } else {
        $feedback = '<div class="alert alert-warning">⚠️ Please enter a valid promotion fee.</div>';
    }
}
?>

<div class="page-wrapper">
    <section>
        <div class="container-fluid">
            <div class="card">
                <div class="card-header bg-primary text-white fw-bold">
                    Manage Settings
                </div>
                <div class="card-body">

                    <?php echo $feedback; ?>

                    <form method="POST" class="row g-3">
                        <div class="col-md-6">
                            <label for="promotion_fee" class="form-label">Promotion Fee (USD)</label>
                            <input type="number" step="0.01" name="promotion_fee" id="promotion_fee" 
                                   class="form-control" value="<?php echo htmlspecialchars($current_fee); ?>" required>
                        </div>

                        <div class="col-12">
                            <button type="submit" class="btn btn-success">💾 Save Settings</button>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </section>
</div>

<?php include 'footer.php'; ?>
