<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();
require_once("../_db.php"); // your DB connection file

// Check if form submitted
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['email']) && isset($_POST['password'])) {
    $email = trim($_POST['email']);
    $password = trim($_POST['password']);

    // Basic validation
    if (empty($email) || empty($password)) {
        header("Location: ../login.php?status=error&message=" . urlencode("Enter all fields"));
        exit;
    }

    // Query the database for the user
    $query = "SELECT userid, email, password, full_name, account_balance, status FROM user_login WHERE email = ?";
    $stmt = $conn->prepare($query);
    if (!$stmt) {
        header("Location: ../login.php?status=error&message=" . urlencode("Database error"));
        exit;
    }

    $stmt->bind_param("s", $email);
    $stmt->execute();
    $result = $stmt->get_result();

    // Check if user exists
    if ($result->num_rows === 1) {
        $user = $result->fetch_assoc();

        // Compare password (if hashed)
        if (password_verify($password, $user['password'])) {
            if ($user['status'] === 'active') {
                $_SESSION['userid'] = $user['userid'];
                $_SESSION['email'] = $user['email'];
                $_SESSION['full_name'] = $user['full_name'];
                $_SESSION['account_balance'] = $user['account_balance'];

                header("Location: ../dashboard/dashboard.php?status=success&message=" . urlencode("Login Successfully"));
                exit;
            } else {
                header("Location: ../login.php?status=error&message=" . urlencode("Your account is not yet activated"));
                exit;
            }
        } else {
            header("Location: ../login.php?status=error&message=" . urlencode("Incorrect password"));
            exit;
        }
    } else {
        header("Location: ../login.php?status=error&message=" . urlencode("User not found"));
        exit;
    }
} else {
    header("Location: ../login.php?status=error&message=" . urlencode("Invalid request"));
    exit;
}
?>
