<?php 
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include 'head.php';
include 'header.php';
include 'sidebar.php';

if (!isset($_SESSION['userid'])) {
    header("Location: login.php");
    exit();
}

$feedback = "";

// Load PHPMailer
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
require 'vendor/autoload.php';

// Handle sales request submission
if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['action']) && $_POST['action'] === "send_request") {
    $userid       = $_POST['userid'];
    $product_id   = $_POST['product_id'];
    $sale_amount  = $_POST['sale_amount'];
    $notes        = $_POST['notes'];
    $requested_by = $_POST['requested_by']; // admin name

    if (!empty($userid) && !empty($product_id) && !empty($sale_amount) && !empty($requested_by)) {
        $stmt = $conn->prepare("
            INSERT INTO product_sales_requests 
            (userid, product_id, sale_amount, notes, status, request_date, requested_by) 
            VALUES (?, ?, ?, ?, 'pending', NOW(), ?)
        ");
        $stmt->bind_param("ssdss", $userid, $product_id, $sale_amount, $notes, $requested_by);

        if ($stmt->execute()) {
            // ✅ Fetch user and product details for email
            $userQuery = $conn->prepare("SELECT full_name, email FROM user_login WHERE userid = ?");
            $userQuery->bind_param("s", $userid);
            $userQuery->execute();
            $userResult = $userQuery->get_result();
            $userData = $userResult->fetch_assoc();

            $productQuery = $conn->prepare("SELECT product_name FROM products WHERE product_id = ?");
            $productQuery->bind_param("s", $product_id);
            $productQuery->execute();
            $productResult = $productQuery->get_result();
            $productData = $productResult->fetch_assoc();

            $recipientName = $userData['full_name'];
            $recipientEmail = $userData['email'];
            $productName = $productData['product_name'];
            $quantity = $sale_amount;

            // ✅ Email content
            $subject = "New Purchase Interest in Your Portfolio";
            $message = "
            <html>
            <head><title>$subject</title></head>
            <body>
                <p>Dear {$recipientName},</p>
                <p>We are pleased to inform you that an individual has shown strong interest in purchasing 
                <strong>{$quantity} units of “{$productName}”</strong> listed on your marketing portfolio.</p>
                <p>To proceed and secure this sale, we kindly advise you to log in to your market portfolio immediately and complete the transaction process. Once the sale is finalized, the corresponding commission will be credited directly to your portfolio account.</p>
                <p>Acting promptly will ensure the order is processed without delay and your earnings are realized smoothly.</p>
                <p>Should you require any guidance during this process, please feel free to reach out—we are always here to assist you.</p>
                <p>Congratulations in advance on your upcoming commission!</p>
                <br>
                <p>Best regards,<br>ANDY JASSY K.<br>CEO & Marketing Strategist Amazon Choicy Digital Marketing
                </p>
                <!-- Contact Section -->
                <table style='margin-top: 20px; font-size: 14px; color: #555;'>
                    <tr>
                        <td style='padding: 4px;'>📧</td>
                        <td style='padding: 4px;'>
                            <a href='mailto:choicydigitalmarketing@gmail.com' style='color: #555; text-decoration: none;'>
                                choicydigitalmarketing@gmail.com
                            </a>
                        </td>
                    </tr>
                    <tr>
                        <td style='padding: 4px;'>📞</td>
                        <td style='padding: 4px;'>
                            <a href='tel:+18124557252' style='color: #555; text-decoration: none;'>
                                +1 (812) 455-7252
                            </a>
                        </td>
                    </tr>
                    <tr>
                        <td style='padding: 4px;'>📍</td>
                        <td style='padding: 4px;'>United States</td>
                    </tr>
                    <tr>
                        <td style='padding: 4px;'>🌐</td>
                        <td style='padding: 4px;'>
                            <a href='https://choicydigitals.org' target='_blank' style='color: #555; text-decoration: none;'>
                                https://choicydigitals.org
                            </a>
                        </td>
                    </tr>
                </table>
            </body>
            </html>";

            // ✅ Send mail with PHPMailer
            $mail = new PHPMailer(true);
            try {
                // Server settings
                $mail->isSMTP();
                $mail->Host       = 'mail.choicydigitals.org'; 
                $mail->SMTPAuth   = true;
                $mail->Username   = 'support@choicydigitals.org'; 
                $mail->Password   = '@choicydigitals.org'; 
                $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
                $mail->Port       = 587;

                // Recipients
                $mail->setFrom('support@choicydigitals.org', 'Choicy Digitals');
                $mail->addAddress($recipientEmail, $recipientName);

                // Content
                $mail->isHTML(true);
                $mail->Subject = $subject;
                $mail->Body    = $message;

                $mail->send();
                $feedback = '<div class="alert alert-success">✅ Sales request sent successfully and email notification delivered.</div>';
            } catch (Exception $e) {
                $feedback = '<div class="alert alert-warning">⚠️ Sales request saved, but email failed. Error: ' . $mail->ErrorInfo . '</div>';
            }
        } else {
            $feedback = '<div class="alert alert-danger">❌ Failed to send sales request. Please try again.</div>';
        }
    } else {
        $feedback = '<div class="alert alert-warning">⚠️ Please fill in all required fields.</div>';
    }
}

// Fetch all users
$users = $conn->query("SELECT userid, full_name FROM user_login ORDER BY full_name ASC");

// Fetch all products
$products = $conn->query("SELECT product_id, product_name FROM products ORDER BY product_name ASC");

// Fetch existing requests
$requests = $conn->query("
    SELECT r.id, r.userid, u.full_name, r.product_id, p.product_name, 
           r.sale_amount, r.notes, r.status, r.request_date, r.requested_by
    FROM product_sales_requests r
    INNER JOIN user_login u ON r.userid = u.userid
    INNER JOIN products p ON r.product_id = p.product_id
    ORDER BY r.request_date DESC
");
?>


<div class="page-wrapper">
    <section>
        <div class="container-fluid">
            <h4 class="fw-bold mb-3">📩 Send Sales Request</h4>

            <?php echo $feedback; ?>

            <div class="card mb-4">
                <div class="card-header bg-primary text-white fw-bold">
                    Create Sales Request
                </div>
                <div class="card-body">
                    <form method="POST" class="row g-3">
                        <input type="hidden" name="action" value="send_request">

                        <div class="col-md-4">
                            <label for="userid" class="form-label">Select User</label>
                            <select name="userid" id="userid" class="form-select" required>
                                <option value="">-- Choose User --</option>
                                <?php while ($u = $users->fetch_assoc()): ?>
                                    <option value="<?= $u['userid']; ?>">
                                        <?= htmlspecialchars($u['full_name']); ?> (#<?= $u['userid']; ?>)
                                    </option>
                                <?php endwhile; ?>
                            </select>
                        </div>

                        <div class="col-md-4">
                            <label for="product_id" class="form-label">Select Product</label>
                            <select name="product_id" id="product_id" class="form-select" required>
                                <option value="">-- Choose Product --</option>
                                <?php while ($p = $products->fetch_assoc()): ?>
                                    <option value="<?= $p['product_id']; ?>">
                                        <?= htmlspecialchars($p['product_name']); ?>
                                    </option>
                                <?php endwhile; ?>
                            </select>
                        </div>

                        <div class="col-md-4">
                            <label for="sale_amount" class="form-label">Sale Amount (Units)</label>
                            <input type="number" step="1" name="sale_amount" id="sale_amount" class="form-control" required>
                        </div>

                        <div class="col-md-6">
                            <label for="requested_by" class="form-label">Admin Name</label>
                            <input type="text" name="requested_by" id="requested_by" class="form-control" placeholder="Enter your name" required>
                        </div>

                        <div class="col-12">
                            <label for="notes" class="form-label">Comment / Description</label>
                            <textarea name="notes" id="notes" class="form-control" rows="3" placeholder="Add description for this sales request (optional)"></textarea>
                        </div>

                        <div class="col-12">
                            <button type="submit" class="btn btn-success">📤 Send Request</button>
                        </div>
                    </form>
                </div>

                <!-- Requests displayed right under the form -->
                <div class="card-body border-top mt-3">
                    <h5 class="fw-bold mb-3">📋 Recent Sales Requests</h5>
                    <div class="table-responsive">
                        <table class="table table-striped align-middle">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>User</th>
                                    <th>Product</th>
                                    <th>Sale Amount (Units)</th>
                                    <th>Comment</th>
                                    <th>Status</th>
                                    <th>Requested By</th>
                                    <th>Requested At</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                if ($requests->num_rows > 0) {
                                    $count = 1;
                                    while ($row = $requests->fetch_assoc()) {
                                        echo "<tr>
                                                <td>{$count}</td>
                                                <td>" . htmlspecialchars($row['full_name']) . " (#{$row['userid']})</td>
                                                <td>" . htmlspecialchars($row['product_name']) . "</td>
                                                <td>" . number_format($row['sale_amount']) . " units</td>
                                                <td>" . (!empty($row['notes']) ? htmlspecialchars($row['notes']) : "<em class='text-muted'>No comment</em>") . "</td>
                                                <td><span class='badge bg-" . ($row['status'] == 'pending' ? "warning" : ($row['status'] == 'approved' ? "success" : "danger")) . "'>" . ucfirst($row['status']) . "</span></td>
                                                <td>" . htmlspecialchars($row['requested_by']) . "</td>
                                                <td>" . date("M d, Y h:i A", strtotime($row['request_date'])) . "</td>
                                              </tr>";
                                        $count++;
                                    }
                                } else {
                                    echo "<tr><td colspan='8' class='text-center text-muted'>😕 No sales requests yet.</td></tr>";
                                }
                                ?>
                            </tbody>
                        </table>
                    </div>
                </div>

            </div> <!-- end card -->

        </div>
    </section>
</div>

<?php include 'footer.php'; ?>
