<?php 
include 'head.php';
include 'header.php';
?>

<body class="skin-default fixed-layout">
    <div id="main-wrapper">
        <?php 
        include 'sidebar.php';
        if (isset($message)) {
            foreach ($message as $message) {
                echo '<div class="message"><span>' . $message . '</span> <i class="fas fa-times" onclick="this. parentElement.style.display = `none`;"></i> </div>';
            };
        };
        ?>
        
        <div class="page-wrapper">
            <div class="container-fluid">
                <?php include 'nav.php'; ?>
                <div class="container">
                   
                    <!-- DETAILS/DELETE MODAL -->
            <div class=""> 
            <?php
// Assuming you have a database connection established
if (isset($_GET['rental_id'])) {
    $rental_id = $_GET['rental_id'];

    // Fetch blog data from the database based on the provided rental_id
    $query = "SELECT * FROM rentals WHERE rental_id = ?";
    
    if ($stmt = $conn->prepare($query)) {
        $stmt->bind_param("s", $rental_id);
        
        if ($stmt->execute()) {
            $result = $stmt->get_result();

            // Check if there are rows in the result set
            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                $bedroomsArray = array($row['bedroom_category']);
            
?>

                <div class="text-right my-4">
                        <a href="#" data-toggle="modal" data-target="#myModal" class="btn btn-info "><i class="bi bi-pencil-square"></i> Edit</a>
            
                        <a href="delete-rental.php?delete=<?php echo $row['id']; ?>" class="btn btn-danger" onclick="return confirm('are you sure you want to delete this?');"><i class="bi bi-trash3-fill"></i> Delete</a>
                </div>
                <div class=" card">
                    <div class=" card-header">
                        <h3 class="">Manage Renatal Details</h3>
                    </div> 
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <img src="../rental/<?php echo $row['nft_img']; ?>" class="img-fluid" height="700" alt="">
                            </div>
                            
                            <div class="col-md-3">
                                <h2>Bedrooms:</h2>
                                <p><?php echo html_entity_decode($row['bedroom_category']); ?></p>
                                <h2>Location:</h2>
                                <p><?php echo html_entity_decode($row['location']); ?></p>
                                <h2>Price:</h2>
                                <p>$<?php echo number_format($row['price']); ?>/mo</p>
                                <h2>Type:</h2>
                                <p><?php echo html_entity_decode($row['type']); ?></p>
                                
                            </div>

                            <div class="col-md-3">

                                <h2>Bathrooms:</h2>
                                <p><?php echo html_entity_decode($row['baths']); ?></p>

                                <h2>Description:</h2>
                                <p><?php echo html_entity_decode($row['description']); ?></p>
                                <h2>Heights:</h2>
                                <p><?php echo html_entity_decode($row['heights']); ?></p>
                                <h2>Country:</h2>
                                <p><?php echo html_entity_decode($row['country']); ?></p>
                            </div>
                     
                    </div>  
                </div>                            
            </div>





        
        

            <!-- The Modal -->
          <div class="modal fade" id="myModal">
            <div class="modal-dialog modal-lg">
              <div class="modal-content">
              
                <!-- Modal Header -->
                <div class="modal-header">
                  <h4 class="modal-title">Manage Services</h4>
                  <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                
                <!-- Modal body -->
                <div class="modal-body">
                <form action="manage-rental-process.php" method="post" enctype="multipart/form-data">

                    <!-- Add a hidden input field to store the rental ID -->
                    <input type="hidden" name="rental_id" value="<?php echo $row['rental_id']; ?>">

                  <div class="form-group">
                    <input type="text" name="bedrooms" placeholder="Enter bedrooms" class="form-control my-2" required value="<?php echo $row['bedroom_category']; ?>">
                      <!-- <input type="text" name="p_description" placeholder="Enter the service full description" class="form-control" required> -->

                  </div>

                  <div class="form-group">
                    <input type="text" name="baths" placeholder="Enter baths" class="form-control my-2  " required value="<?php echo $row['baths']; ?>">
                      <!-- <input type="text" name="p_description" placeholder="Enter the service full description" class="form-control" required> -->

                  </div>

                  <div class="form-group">
                    <input type="text" name="location" placeholder="Enter location" class="form-control my-2  " required value="<?php echo $row['location']; ?>">
                      <!-- <input type="text" name="p_description" placeholder="Enter the service full description" class="form-control" required> -->

                  </div>
                
                

                  <div class="form-group">
                      <input type="text" name="heights" placeholder="Enter heights" class="form-control my-2  " value="<?php echo $row['heights']; ?>" required>

                  </div>
                  <div class="form-group">
                      <input type="text" name="price" placeholder="Enter price" class="form-control my-2  " value="<?php echo $row['price']; ?>" required>

                  </div>
                  <div class="form-group">
                      <input type="text" name="description" placeholder="Enter description" class="form-control my-2  " value="<?php echo $row['description']; ?>" required>

                  </div>

                  <div class="form-group">
                      <input type="text" name="type" placeholder="Enter Type" class="form-control my-2  " value="<?php echo $row['type']; ?>" required>

                  </div>

                  <div class="form-group">
                      <input type="text" name="country" placeholder="Enter country" class="form-control my-2  " value="<?php echo $row['country']; ?>" required>

                  </div>
                  
                  <div class="form-group">
                    <input type="file" name="nft_img" accept="image/png, image/jpeg, image/jpg" class="form-control-file box" value="<?php echo $row['nft_img']; ?>" >
                  </div>
                  

                <!-- Modal footer -->
                <div class="modal-footer">
                <!-- Update button with a different name -->
                    <button type="submit" name="update_rental" class="btn btn-success bg-warn">Update</button>
                    <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                    </div>
                </form>
              </div>
            </div>
        </div> 
        </div> 
      </div>
    </section>
            </div>
          </div>
        </div>
        <?php } else {
                echo "No blog found for the provided rental_id.";
            }

            // Close the result set
            $result->close();
        } else {
            echo "Error executing the query: " . $stmt->error;
        }

        // Close the prepared statement
        $stmt->close();
    } else {
        echo "Error preparing the query: " . $conn->error;
    }
} else {
    echo "No rental_id provided in the URL.";
}
 ?>
    <?php
    include 'footer.php';
    ?>
    

