<?php
// Include your database connection file
include_once("../_db.php");

// Initialize a success message variable
$successMessage = "";

// Check if form is submitted
if (isset($_POST['btnEditAmount'])) {
    // Retrieve form data
    $newBalance = $_POST['newBalance'];
    $newProfitBalance = $_POST['newProfitBalance'];
    $newTotalWithdrawal = $_POST['newTotalWithdrawal'];
    $newTotalBonus = $_POST['newTotalBonus'];
    $id = $_POST['id']; // Assuming user ID is passed through the form

    // Update user's account details
    $sql = "UPDATE user_login SET account_balance = ?, profit_balance = ?, total_withdrawal = ?, total_bonus = ? WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ssssi", $newBalance, $newProfitBalance, $newTotalWithdrawal, $newTotalBonus, $id);

    if ($stmt->execute()) {
        // Set success message
        $successMessage = "Account details updated successfully!";
    } else {
        // Error updating account details
        echo "Error updating account details: " . $conn->error;
    }

    // Close statement
    $stmt->close();
}

// Retrieve the user ID from the URL parameter
$id = $_GET['id'];

// Fetch the user's current balances
$sql = "SELECT account_balance, profit_balance, total_withdrawal, total_bonus FROM user_login WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $id);
$stmt->execute();
$stmt->bind_result($currentBalance, $currentProfitBalance, $currentTotalWithdrawal, $currentTotalBonus);
$stmt->fetch();
$stmt->close();
?>

<?php
include 'head.php';
include 'header.php';
?>

<body class="skin-default fixed-layout">
    <div id="main-wrapper">
        <?php include 'sidebar.php'; ?>
        <div class="page-wrapper">
            <section>
                <div class="">
                    <?php include 'nav1.php'; ?>
                    <div class="container-fluid">
                        <div class="card">
                            <div class="card-header">
                                <!-- Success Message -->
                                <?php if (!empty($successMessage)) : ?>
                                    <div class="alert alert-success">
                                        <?php echo $successMessage; ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table">
                                        <tbody>
                                            <!-- HTML Form for updating balance -->
                                            <form action="" method="post">
                                                <div class="form-group">
                                                    <label for="newBalance">New Balance:</label>
                                                    <input type="text" class="form-control" name="newBalance" value="<?php echo $currentBalance; ?>" required>
                                                </div>
                                                <div class="form-group">
                                                    <label for="newProfitBalance">New Profit Balance:</label>
                                                    <input type="text" class="form-control" name="newProfitBalance" value="<?php echo $currentProfitBalance; ?>" required>
                                                </div>
                                                <div class="form-group">
                                                    <label for="newTotalWithdrawal">New Total Withdrawal:</label>
                                                    <input type="text" class="form-control" name="newTotalWithdrawal" value="<?php echo $currentTotalWithdrawal; ?>" required>
                                                </div>
                                                <div class="form-group">
                                                    <label for="newTotalBonus">New Total Bonus:</label>
                                                    <input type="text" class="form-control" name="newTotalBonus" value="<?php echo $currentTotalBonus; ?>" required>
                                                </div>
                                                <!-- Hidden input to pass user ID -->
                                                <input type="hidden" name="id" value="<?php echo $id; ?>">
                                                <button type="submit" name="btnEditAmount" class="btn btn-success">Update Balance</button>
                                                <a href="info.php" class="btn btn-secondary ml-3">Go Back</a>
                                            </form>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
    <?php include 'footer.php'; ?>
</body>
</html>
