<?php
include "./include/head.php";
include "sidebar.php";
include "./include/navbar.php";

if (!isset($_SESSION['userid'])) {
    header("Location: login.php");
    exit();
}

$userid = $_SESSION['userid'];
$successMsg = $errorMsg = "";

// ✅ Handle social media form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $facebook  = trim($_POST['facebook']);
    $instagram = trim($_POST['instagram']);
    $twitter   = trim($_POST['twitter']);
    $linkedin  = trim($_POST['linkedin']);
    $tiktok    = trim($_POST['tiktok']);

    $stmt = $conn->prepare("
        UPDATE user_login 
        SET facebook_url=?, instagram_url=?, twitter_url=?, linkedin_url=?, tiktok_url=?
        WHERE userid=?
    ");
    
    if ($stmt) {
        $stmt->bind_param("ssssss", $facebook, $instagram, $twitter, $linkedin, $tiktok, $userid);
        if ($stmt->execute()) {
            $successMsg = "✅ Your social media links have been updated successfully!";
        } else {
            $errorMsg = "❌ Failed to update your social media links. Please try again.";
        }
        $stmt->close();
    } else {
        $errorMsg = "❌ Database error: " . $conn->error;
    }
}

// ✅ Fetch current social links
$stmt = $conn->prepare("SELECT facebook_url, instagram_url, twitter_url, linkedin_url, tiktok_url FROM user_login WHERE userid=?");
$stmt->bind_param("s", $userid);
$stmt->execute();
$userLinks = $stmt->get_result()->fetch_assoc();
?>

<!-- Bootstrap 5 -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">

<style>
    html, body {
        height: 100%;
        background-color: #f8f9fa;
        margin: 0;
    }
    .page-wrapper {
        display: flex;
        flex-direction: column;
        min-height: 100vh;
    }
    .content {
        flex: 1;
    }
</style>

<div class="page-wrapper">
    <div class="content container py-5">

        <!-- Alert Messages -->
        <?php if (!empty($successMsg)): ?>
            <div class="alert alert-success"><?= htmlspecialchars($successMsg) ?></div>
        <?php endif; ?>
        <?php if (!empty($errorMsg)): ?>
            <div class="alert alert-danger"><?= htmlspecialchars($errorMsg) ?></div>
        <?php endif; ?>

        <!-- Social Media Linking Form -->
        <div class="p-4 bg-white rounded shadow-sm">
            <h5 class="fw-bold mb-3">🔗 Link Your Social Media Accounts</h5>
            <form method="post">
                <div class="row g-3">
                    <div class="col-md-6">
                        <input type="url" name="facebook" class="form-control" placeholder="Facebook URL" value="<?= htmlspecialchars($userLinks['facebook_url'] ?? '') ?>">
                    </div>
                    <div class="col-md-6">
                        <input type="url" name="instagram" class="form-control" placeholder="Instagram URL" value="<?= htmlspecialchars($userLinks['instagram_url'] ?? '') ?>">
                    </div>
                    <div class="col-md-6">
                        <input type="url" name="twitter" class="form-control" placeholder="Twitter URL" value="<?= htmlspecialchars($userLinks['twitter_url'] ?? '') ?>">
                    </div>
                    <div class="col-md-6">
                        <input type="url" name="linkedin" class="form-control" placeholder="LinkedIn URL" value="<?= htmlspecialchars($userLinks['linkedin_url'] ?? '') ?>">
                    </div>
                    <div class="col-md-6">
                        <input type="url" name="tiktok" class="form-control" placeholder="TikTok URL" value="<?= htmlspecialchars($userLinks['tiktok_url'] ?? '') ?>">
                    </div>
                </div>
                <button type="submit" class="btn btn-primary mt-3">Save Links</button>
            </form>
        </div>

        <!-- Display Linked Accounts -->
        <div class="mt-3">
            <?php if (!empty($userLinks['facebook_url'])): ?>
                <a href="<?= htmlspecialchars($userLinks['facebook_url']) ?>" target="_blank" class="btn btn-outline-primary me-2"><i class="fab fa-facebook"></i> Facebook</a>
            <?php endif; ?>
            <?php if (!empty($userLinks['instagram_url'])): ?>
                <a href="<?= htmlspecialchars($userLinks['instagram_url']) ?>" target="_blank" class="btn btn-outline-danger me-2"><i class="fab fa-instagram"></i> Instagram</a>
            <?php endif; ?>
            <?php if (!empty($userLinks['twitter_url'])): ?>
                <a href="<?= htmlspecialchars($userLinks['twitter_url']) ?>" target="_blank" class="btn btn-outline-info me-2"><i class="fab fa-twitter"></i> Twitter</a>
            <?php endif; ?>
            <?php if (!empty($userLinks['linkedin_url'])): ?>
                <a href="<?= htmlspecialchars($userLinks['linkedin_url']) ?>" target="_blank" class="btn btn-outline-secondary me-2"><i class="fab fa-linkedin"></i> LinkedIn</a>
            <?php endif; ?>
            <?php if (!empty($userLinks['tiktok_url'])): ?>
                <a href="<?= htmlspecialchars($userLinks['tiktok_url']) ?>" target="_blank" class="btn btn-outline-dark me-2"><i class="fab fa-tiktok"></i> TikTok</a>
            <?php endif; ?>
        </div>
    </div>

    <?php include "footer.php"; ?>
</div>
