<?php
include "./include/head.php";
include "sidebar.php";
include "./include/navbar.php";

if (!isset($_SESSION['userid'])) {
    header("Location: login.php");
    exit();
}

$userid = $_SESSION['userid'];
$success = $error = "";

// Fetch user profile
$user_query = mysqli_query($conn, "SELECT * FROM user_login WHERE userid = '$userid' LIMIT 1");
$user = mysqli_fetch_assoc($user_query);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = mysqli_real_escape_string($conn, $_POST['full_name']);
    $email = mysqli_real_escape_string($conn, $_POST['email']);
    $phone = mysqli_real_escape_string($conn, $_POST['phone_number']);

    // Optional password change
    $new_password = mysqli_real_escape_string($conn, $_POST['password']);
    if (!empty($new_password)) {
        $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
        $update = mysqli_query($conn, "UPDATE user_login SET name='$name', email='$email', phone='$phone', password='$hashed_password' WHERE userid='$userid'");
    } else {
        $update = mysqli_query($conn, "UPDATE user_login SET name='$name', email='$email', phone='$phone' WHERE userid='$userid'");
    }

    if ($update) {
        $success = "✅ Profile updated successfully.";
        // Refresh data
        $user = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM user WHERE userid = '$userid' LIMIT 1"));
    } else {
        $error = "❌ Failed to update profile. Please try again.";
    }
}
?>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
    .profile-card {
        background: #fff;
        border: none;
        border-radius: 20px;
        box-shadow: 0 10px 25px rgba(0, 0, 0, 0.08);
        transition: all 0.3s ease;
    }

    .profile-card:hover {
        transform: translateY(-4px);
    }

    .btn-gradient {
        background: linear-gradient(135deg, #667eea, #764ba2);
        color: white;
        font-weight: 600;
    }

    .form-control {
        border-radius: 50px;
        padding-left: 20px;
        padding-right: 20px;
    }

    body {
        background: #f4f6fa;
    }

    label {
        font-weight: 500;
    }
</style>

<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-lg-7">

            <div class="text-center mb-5">
                <h2 class="fw-bold text-white">👤 My Profile</h2>
                <p class="text-white">Update your personal information below.</p>
            </div>

            <?php if ($success) : ?>
                <div class="alert alert-success text-center shadow-sm"><?php echo $success; ?></div>
            <?php elseif ($error) : ?>
                <div class="alert alert-danger text-center shadow-sm"><?php echo $error; ?></div>
            <?php endif; ?>

            <div class="card profile-card p-4">
                <form method="POST" class="row g-4">
                    <div class="col-12">
                        <label class="form-label">Full Name</label>
                        <input type="text" name="name" class="form-control form-control-lg" value="<?php echo htmlspecialchars($user['full_name'] ?? ''); ?>" required>
                    </div>

                    <div class="col-md-6">
                        <label class="form-label">Email Address</label>
                        <input type="email" name="email" class="form-control" value="<?php echo htmlspecialchars($user['email'] ?? ''); ?>" required>
                    </div>

                    <div class="col-md-6">
                        <label class="form-label">Phone Number</label>
                        <input type="text" name="phone" class="form-control" value="<?php echo htmlspecialchars($user['phone_number'] ?? ''); ?>" required>
                    </div>

                    <div class="col-12">
                        <label class="form-label">Change Password <small class="text-muted">(Leave blank to keep current)</small></label>
                        <input type="password" name="password" class="form-control" placeholder="New Password (Optional)">
                    </div>

                    <div class="col-12 text-center">
                        <button type="submit" class="btn btn-lg btn-gradient rounded-pill px-5">
                            <i class="fas fa-save me-2"></i> Save Changes
                        </button>
                    </div>
                </form>
            </div>

            <div class="text-center mt-4">
                <a href="dashboard.php" class="text-muted text-decoration-none small">
                    <i class="fas fa-arrow-left me-1"></i> Back to Dashboard
                </a>
            </div>
        </div>
    </div>
</div>

<?php include "footer.php"; ?>
