<?php include "./include/header.php"; ?>

<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-lg-6 col-xl-5">
            <div class="card shadow-lg border-0 rounded-4">
                <div class="card-body p-5">
                    <h2 class="text-center mb-4 text-primary">Login to Your Account</h2>

                    <form method="POST" action="./authenticator/login-process.php" class="needs-validation" novalidate>
                        <div class="form-floating mb-3">
                            <input type="email" name="email" class="form-control" id="emailInput" placeholder="name@example.com" required>
                            <label for="emailInput">Email address</label>
                            <div class="invalid-feedback">Please enter a valid email address.</div>
                        </div>

                        <div class="form-floating mb-3">
                            <input type="password" name="password" class="form-control" id="passwordInput" placeholder="Password" required>
                            <label for="passwordInput">Password</label>
                            <div class="invalid-feedback">Please enter your password.</div>
                        </div>

                        <div class="mb-3 form-check">
                            <input type="checkbox" class="form-check-input" id="rememberCheck">
                            <label class="form-check-label" for="rememberCheck">Remember me</label>
                        </div>

                        <button type="submit" class="btn btn-success w-100 py-2">Login</button>

                        <div class="text-center mt-3">
                            <small>
                                Don't have an account? <a href="signup.php" class="text-decoration-none">Register now</a><br>
                                
                            </small>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// Bootstrap 5 validation
(() => {
    'use strict';
    const forms = document.querySelectorAll('.needs-validation');
    Array.from(forms).forEach(form => {
        form.addEventListener('submit', event => {
            if (!form.checkValidity()) {
                event.preventDefault()
                event.stopPropagation()
            }
            form.classList.add('was-validated')
        }, false)
    });
})();
</script>

<?php include "./include/footer.php"; ?>
