<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
include 'head.php';
include 'header.php';
include_once("../_db.php");

if (!isset($_GET['id'])) {
    echo "Invalid request.";
    exit;
}

$id = $_GET['id'];
$status = $message = '';

// Fetch current product data
$stmt = $conn->prepare("SELECT * FROM products WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$product = $result->fetch_assoc();

if (!$product) {
    echo "Product not found.";
    exit;
}

// Update logic
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $product_name = trim($_POST['product_name']);
    $description = trim($_POST['description']);
    $amount = trim($_POST['amount']);
    $amount_bought = trim($_POST['amount_bought']);
    $amount_left = trim($_POST['amount_left']);

    $update = $conn->prepare("UPDATE products SET product_name=?, description=?, amount=?, amount_bought=?, amount_left=? WHERE id=?");
    $update->bind_param("sssssi", $product_name, $description, $amount, $amount_bought, $amount_left, $id);

    if ($update->execute()) {
        $status = 'success';
        $message = "✅ Product updated successfully.";
        // Refresh product data
        $product = array_merge($product, $_POST);
    } else {
        $status = 'error';
        $message = "❌ Failed to update product.";
    }
}
include 'sidebar.php';
?>



<body class="skin-default fixed-layout">
    <div id="main-wrapper">
        <div class="page-wrapper">
            <div class="container-fluid">
                <?php include 'nav.php'; ?>
                <div class="container">


                    <!-- Add Product Modal (Only major changes shown) -->


                    <!-- Display Products -->
                    <section>
                        <div class="d-flex justify-content-end align-items-center">
                            <div class="container-fluid">
                                <div class="card">


                                <div class="card-body">
    <h3>Edit Product</h3>

    <?php if (!empty($message)) : ?>
        <div class="alert alert-<?php echo $status === 'success' ? 'success' : 'danger'; ?>">
            <?php echo htmlspecialchars($message); ?>
        </div>
    <?php endif; ?>

    <form method="POST">
        <div class="form-group my-2">
            <label>Product Name</label>
            <input type="text" name="product_name" value="<?php echo htmlspecialchars($product['product_name']); ?>" class="form-control" required>
        </div>

        <div class="form-group my-2">
            <label>Description</label>
            <textarea name="description" class="form-control" required><?php echo htmlspecialchars($product['description']); ?></textarea>
        </div>

        <div class="form-group my-2">
            <label>Amount</label>
            <input type="text" name="amount" value="<?php echo htmlspecialchars($product['amount']); ?>" class="form-control" required>
        </div>

        <div class="form-group my-2">
            <label>Amount Bought</label>
            <input type="text" name="amount_bought" value="<?php echo htmlspecialchars($product['amount_bought']); ?>" class="form-control">
        </div>

        <div class="form-group my-2">
            <label>Amount Left</label>
            <input type="text" name="amount_left" value="<?php echo htmlspecialchars($product['amount_left']); ?>" class="form-control">
        </div>

        <button type="submit" class="btn btn-primary my-2">Update Product</button>
        <a href="admin-products.php" class="btn btn-secondary my-2">Back</a>
    </form>
</div>

                                </div>
                            </div>
                        </div>
                    </section>
                </div>
            </div>
        </div>
        <?php include 'footer.php'; ?>
</body>