<?php
include_once("../_db.php");

// Initialize variables
$status = $message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update_rental'])) {
    $rental_id = $_POST['rental_id'];
    $bedrooms = $_POST['bedrooms'];
    $baths = $_POST['baths'];
    $location = $_POST['location'];
    $heights = $_POST['heights'];
    $price = $_POST['price'];
    $description = $_POST['description'];
    $type = $_POST['type'];
    $country = $_POST['country'];
    
    // Check if all fields are filled
    if (empty($rental_id) || empty($bedrooms) || empty($baths) || empty($location) || empty($heights) || empty($price) || empty($description) || empty($type) || empty($country)) {
        $status = 'error';
        $message = 'Please fill all fields';
    } else {
        // Prepare update query
        $updateQuery = "UPDATE rentals SET bedroom_category=?, baths=?, location=?, heights=?, price=?, description=?, type=?, country=? WHERE rental_id=?";
        $updateStmt = $conn->prepare($updateQuery);

        // Check if prepare() was successful
        if ($updateStmt) {
            $updateStmt->bind_param("sssssssss", $bedrooms, $baths, $location, $heights, $price, $description, $type, $country, $rental_id);

            if ($updateStmt->execute()) {
                $status = 'success';
                $message = 'Rental updated successfully';

                // Check if a new image is uploaded
                if (!empty($_FILES['nft_img']['name'])) {
                    $uploadDirectory = '../rental/';
                    $fileName = basename($_FILES['nft_img']['name']);
                    $targetPath = $uploadDirectory . $fileName;

                    // Check if file already exists
                    if (file_exists($targetPath)) {
                        $status = 'error';
                        $message = 'File already exists';
                    } else {
                        // Upload file
                        if (!move_uploaded_file($_FILES['nft_img']['tmp_name'], $targetPath)) {
                            $status = 'error';
                            $message = 'Failed to upload file';
                        } else {
                            // Update image path in database
                            $updateImageQuery = "UPDATE rentals SET nft_img=? WHERE rental_id=?";
                            $updateImageStmt = $conn->prepare($updateImageQuery);

                            if ($updateImageStmt) {
                                $updateImageStmt->bind_param("ss", $fileName, $rental_id);
                                if ($updateImageStmt->execute()) {
                                    $status = 'success';
                                    $message = 'Rental and image updated successfully';
                                } else {
                                    $status = 'error';
                                    $message = 'Failed to update image path in database: ' . $updateImageStmt->error;
                                }
                            } else {
                                $status = 'error';
                                $message = 'Failed to prepare image update SQL statement: ' . $conn->error;
                            }
                        }
                    }
                }
            } else {
                $status = 'error';
                $message = 'Failed to execute update query: ' . $updateStmt->error;
            }
        } else {
            $status = 'error';
            $message = 'Failed to prepare SQL statement: ' . $conn->error;
        }
    }

    // Redirect to a different page or display status message
    // echo '<div style="color: ' . ($status === 'success' ? 'green' : 'red') . ';">' . $message . '</div>';
    header("Location: manage-rentals.php?status=$status&message=$message");
    exit();
}
?>
