<?php   
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include 'head.php';
include 'header.php';
include 'sidebar.php';

if (!isset($_SESSION['userid'])) {
    header("Location: login.php");
    exit();
}

$feedback = "";

// Load PHPMailer
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
require 'vendor/autoload.php';

// Handle sales completion request
if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['action']) && $_POST['action'] === "send_request") {
    $userid       = $_POST['userid'];
    $product_id   = $_POST['product_id'];
    $sale_amount  = $_POST['sale_amount'];
    $notes        = $_POST['notes'];
    $requested_by = $_POST['requested_by']; // admin name

    if (!empty($userid) && !empty($product_id) && !empty($sale_amount) && !empty($requested_by)) {
        $stmt = $conn->prepare("
            INSERT INTO product_sales_requests 
            (userid, product_id, sale_amount, notes, status, request_date, requested_by) 
            VALUES (?, ?, ?, ?, 'pending', NOW(), ?)
        ");
        $stmt->bind_param("sidss", $userid, $product_id, $sale_amount, $notes, $requested_by);

        if ($stmt->execute()) {
            // Fetch user and product
            $userQuery = $conn->prepare("SELECT full_name, email FROM user_login WHERE userid = ?");
            $userQuery->bind_param("s", $userid);
            $userQuery->execute();
            $userData = $userQuery->get_result()->fetch_assoc();

            $productQuery = $conn->prepare("SELECT product_name FROM products WHERE product_id = ?");
            $productQuery->bind_param("i", $product_id);
            $productQuery->execute();
            $productData = $productQuery->get_result()->fetch_assoc();

            $recipientName  = $userData['full_name'];
            $recipientEmail = $userData['email'];
            $productName    = $productData['product_name'];
            $quantity       = $sale_amount;

            // Email content
            $subject = "Sales Completion Request for $productName";
            $message = "
            <html>
            <head><title>$subject</title></head>
            <body>
                <p>Dear {$recipientName},</p>
                <p>This is to notify you that the admin has issued a <strong>Sales Completion Request</strong> 
                for your promoted product <strong>“{$productName}”</strong>.</p>
                <p><strong>Requested Units:</strong> {$quantity}</p>
                <p><strong>Notes:</strong> {$notes}</p>
                <p>Please log in to your dashboard to confirm and finalize this sales process. 
                Once confirmed, your commission will be processed and credited to your account.</p>
                <br>
                <p>Best regards,<br>
                Choicy Digitals Admin Team</p>
            </body>
            </html>";

            // Send with PHPMailer
            // Send with PHPMailer
            $mail = new PHPMailer(true);
            try {
                $mail->isSMTP();
                $mail->Host       = 'mail.choicydigitals.org'; // try also mail.privateemail.com if needed
                $mail->SMTPAuth   = true;
                $mail->Username   = 'support@choicydigitals.org'; 
                $mail->Password   = '@choicydigitals.org'; // <-- Replace with REAL mailbox password
                $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
                $mail->Port       = 587;
            
                // ✅ Disable debug output for production
                $mail->SMTPDebug  = 0;
            
                $mail->setFrom('support@choicydigitals.org', 'Choicy Digitals');
                $mail->addAddress($recipientEmail, $recipientName);
            
                $mail->isHTML(true);
                $mail->Subject = $subject;
                $mail->Body    = $message;
            
                $mail->send();
                $feedback = '<div class="alert alert-success">✅ Sales completion request sent and email delivered.</div>';
            } catch (Exception $e) {
                $feedback = '<div class="alert alert-danger">❌ Request saved, but email failed.</div>';
            }

        } else {
            $feedback = '<div class="alert alert-danger">❌ Failed to create request.</div>';
        }
    } else {
        $feedback = '<div class="alert alert-warning">⚠️ Please fill all required fields.</div>';
    }
}

// Fetch all users
$users = $conn->query("SELECT userid, full_name FROM user_login ORDER BY full_name ASC");

// Fetch all sales completion requests
$requests = $conn->query("
    SELECT r.id, r.userid, u.full_name, r.product_id, p.product_name, 
           r.sale_amount, r.notes, r.status, r.request_date, r.requested_by
    FROM product_sales_requests r
    INNER JOIN user_login u ON r.userid = u.userid
    INNER JOIN products p ON r.product_id = p.product_id
    ORDER BY r.request_date DESC
");
?>


<div class="page-wrapper">
    <section>
        <div class="container-fluid">
            <h4 class="fw-bold mb-3">📩 Send Sales Completion Request</h4>

            <?php echo $feedback; ?>

            <div class="card mb-4">
                <div class="card-header bg-primary text-white fw-bold">
                    Create Sales Completion Request
                </div>
                <div class="card-body">
                    <form method="POST" class="row g-3">
                        <input type="hidden" name="action" value="send_request">

                        <div class="col-md-4">
                            <label for="userid" class="form-label">Select User</label>
                            <select name="userid" id="userid" class="form-select" required>
                                <option value="">-- Choose User --</option>
                                <?php while ($u = $users->fetch_assoc()): ?>
                                    <option value="<?= $u['userid']; ?>">
                                        <?= htmlspecialchars($u['full_name']); ?> (#<?= $u['userid']; ?>)
                                    </option>
                                <?php endwhile; ?>
                            </select>
                        </div>

                        <div class="col-md-4">
                            <label for="product_id" class="form-label">Select Promoted Product</label>
                            <select name="product_id" id="product_id" class="form-select" required>
                                <option value="">-- Choose Product --</option>
                            </select>
                        </div>

                        <div class="col-md-4">
                            <label for="sale_amount" class="form-label">Sale Amount (Units)</label>
                            <input type="number" step="0.01" name="sale_amount" id="sale_amount" class="form-control" required>
                        </div>

                        <div class="col-md-12">
                            <label for="notes" class="form-label">Notes (Optional)</label>
                            <textarea name="notes" id="notes" rows="3" class="form-control" placeholder="Enter any notes..."></textarea>
                        </div>

                        <div class="col-md-6">
                            <label for="requested_by" class="form-label">Admin Name</label>
                            <input type="text" name="requested_by" id="requested_by" class="form-control" placeholder="Enter your name" required>
                        </div>

                        <div class="col-12">
                            <button type="submit" class="btn btn-success">📤 Send Completion Request</button>
                        </div>
                    </form>
                </div>

                <!-- All Requests -->
                <div class="card-body border-top mt-3">
                    <h5 class="fw-bold mb-3">📋 All Sales Completion Requests</h5>
                    <div class="table-responsive">
                        <table class="table table-striped align-middle">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>User</th>
                                    <th>Product</th>
                                    <th>Units</th>
                                    <th>Notes</th>
                                    <th>Status</th>
                                    <th>Requested By</th>
                                    <th>Requested At</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                if ($requests->num_rows > 0) {
                                    $count = 1;
                                    while ($row = $requests->fetch_assoc()) {
                                        echo "<tr>
                                                <td>{$count}</td>
                                                <td>" . htmlspecialchars($row['full_name']) . " (#{$row['userid']})</td>
                                                <td>" . htmlspecialchars($row['product_name']) . "</td>
                                                <td>" . number_format($row['sale_amount'], 2) . "</td>
                                                <td>" . htmlspecialchars($row['notes']) . "</td>
                                                <td><span class='badge bg-" . ($row['status'] == 'pending' ? "warning" : ($row['status'] == 'approved' ? "success" : "danger")) . "'>" . ucfirst($row['status']) . "</span></td>
                                                <td>" . htmlspecialchars($row['requested_by']) . "</td>
                                                <td>" . date("M d, Y h:i A", strtotime($row['request_date'])) . "</td>
                                              </tr>";
                                        $count++;
                                    }
                                } else {
                                    echo "<tr><td colspan='8' class='text-center text-muted'>😕 No sales completion requests yet.</td></tr>";
                                }
                                ?>
                            </tbody>
                        </table>
                    </div>
                </div>

            </div> <!-- end card -->

        </div>
    </section>
</div>

<!-- Ajax script to load user’s promoted products -->
<script>
document.getElementById('userid').addEventListener('change', function() {
    let userid = this.value;
    let productSelect = document.getElementById('product_id');
    productSelect.innerHTML = "<option>Loading...</option>";
    if(userid) {
        fetch("fetch_user_products.php?userid=" + userid)
        .then(res => res.json())
        .then(data => {
            productSelect.innerHTML = "<option value=''>-- Choose Product --</option>";
            if(data.length > 0) {
                data.forEach(p => {
                    productSelect.innerHTML += `<option value="${p.product_id}">${p.product_name}</option>`;
                });
            } else {
                productSelect.innerHTML = "<option value=''>No promoted products</option>";
            }
        });
    }
});
</script>

<?php include 'footer.php'; ?>
