<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include "./include/head.php";
include "sidebar.php";
include "./include/navbar.php";

if (!isset($_SESSION['userid'])) {
    header("Location: login.php");
    exit();
}

$userid = $_SESSION['userid'];
?>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
body { background: #f9fafc; }
.promotions-table { background: #fff; border-radius: 16px; box-shadow: 0 8px 25px rgba(0, 0, 0, 0.05); overflow: hidden; }
.table thead { background-color: #f4f6f8; font-weight: 600; color: #333; }
.table td, .table th { vertical-align: middle; }
.product-img { width: 70px; height: 70px; object-fit: cover; border-radius: 10px; }
.badge-method { background: linear-gradient(45deg, #6a11cb, #2575fc); color: white; padding: 6px 12px; border-radius: 50px; font-size: 0.75rem; }
.btn-view { font-size: 0.875rem; font-weight: 500; color: #2575fc; background: #eef4ff; border: none; padding: 5px 10px; border-radius: 50px; transition: 0.3s ease; }
.btn-view:hover { background: #dbe9ff; }
.btn-activate { font-size: 0.875rem; font-weight: 500; color: white; background: #28a745; padding: 6px 12px; border-radius: 50px; text-decoration: none; }
.btn-activate:hover { background: #218838; }
</style>

<div class="container py-5">
    <div class="text-center mb-5">
        <h2 class="section-title">🎯 All Products & Autopilot Status</h2>
        <p class="small-muted">View all your products. Activate autopilot to start automated promotion.</p>
    </div>

    <div class="promotions-table p-4">
        <div class="table-responsive">
            <table class="table align-middle table-borderless">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Product</th>
                        <th>Description</th>
                        <th>Status</th>
                        <th>Autopilot</th>
                    </tr>
                </thead>
                <tbody>
<?php
// ✅ Fetch only the latest promotion per product for this user
$sql = "
    SELECT p.product_id, p.product_name, p.description, p.image,
           pp.status AS autopilot_status, pp.autopilot, pp.created_at
    FROM product_promotions pp
    INNER JOIN products p ON pp.product_id = p.product_id
    INNER JOIN (
        SELECT product_id, MAX(created_at) AS latest_created
        FROM product_promotions
        WHERE userid = ?
        GROUP BY product_id
    ) latest ON pp.product_id = latest.product_id AND pp.created_at = latest.latest_created
    WHERE pp.userid = ?
    ORDER BY pp.created_at DESC
";

$stmt = $conn->prepare($sql);
if (!$stmt) {
    die("SQL error: " . $conn->error);
}
$stmt->bind_param("ss", $userid, $userid);
$stmt->execute();
$result = $stmt->get_result();

$count = 1;

if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $desc_words = explode(' ', strip_tags($row['description']));
        $short_desc = implode(' ', array_slice($desc_words, 0, 10));

        // Only approved promotions are considered running
        $is_running = ($row['autopilot_status'] === 'approved');
?>
<tr>
    <td><?= $count++ ?></td>
    <td>
        <div class="d-flex align-items-center">
            <img src="./uploads/<?= htmlspecialchars($row['image']) ?>" class="product-img me-3" alt="">
            <div>
                <div class="fw-bold"><?= htmlspecialchars($row['product_name']) ?></div>
                <small class="text-muted">#<?= substr($row['product_id'], 0, 8) ?></small>
            </div>
        </div>
    </td>
    <td><?= htmlspecialchars($short_desc) ?><?= count($desc_words) > 10 ? '...' : '' ?></td>

    <!-- Status Badge -->
    <td>
        <?php if ($is_running): ?>
            <span class="badge bg-success">Approved</span>
        <?php elseif ($row['autopilot_status'] === 'pending'): ?>
            <span class="badge bg-warning text-dark">Pending</span>
        <?php else: ?>
            <span class="badge bg-secondary">Not Activated</span>
        <?php endif; ?>
    </td>

    <!-- Autopilot Action -->
    <td>
        <?php if ($is_running): ?>
            ✅ Running
        <?php else: ?>
            <a href="activate_autopilot.php?product_id=<?= $row['product_id'] ?>" class="btn-activate">
                Activate Autopilot
            </a>
        <?php endif; ?>
    </td>
</tr>

<?php if ($is_running): ?>
<tr>
    <td colspan="5" class="text-start ps-5">
        <a href="view_sales.php?product_id=<?= urlencode($row['product_id']) ?>" 
           class="btn btn-outline-primary btn-sm rounded-pill">
            📊 View Sales Report
        </a>
    </td>
</tr>
<?php endif; ?>

<?php
    }
} else {
    echo "<tr><td colspan='5' class='text-center text-muted'>😕 No products found.</td></tr>";
}
?>
                </tbody>
            </table>
        </div>
    </div>

    <div class="text-center mt-4">
        <a href="dashboard.php" class="text-decoration-none small text-primary">← Back to Dashboard</a>
    </div>
</div>

<?php include "footer.php"; ?>
