<?php
include "./include/head.php";
include "./include/navbar.php";
include "sidebar.php";

if (!isset($_SESSION['userid'])) {
    header("Location: login.php");
    exit();
}

$userid = $_SESSION['userid'];

// Fetch only products not created by any user (admin products)
$product_query = $conn->query("SELECT * FROM products ORDER BY id DESC");
?>

<!-- Bootstrap & FontAwesome -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">

<!-- Custom Styles -->
<style>
    .card-equal {
        display: flex;
        flex-direction: column;
        height: 100%;
        border-radius: 16px;
        border: none;
        overflow: hidden;
        box-shadow: 0 8px 24px rgba(0,0,0,0.08);
        transition: transform 0.3s ease, box-shadow 0.3s ease;
    }

    .card-equal:hover {
        transform: translateY(-5px);
        box-shadow: 0 12px 28px rgba(0,0,0,0.12);
    }

    .card-equal img {
        width: 100%;
        height: 200px;
        object-fit: cover;
    }

    .card-body {
        flex-grow: 1;
        display: flex;
        flex-direction: column;
        padding: 1.5rem;
    }

    .card-title {
        font-weight: 700;
        font-size: 1.2rem;
        color: #1e293b;
    }

    .card-text {
        flex-grow: 1;
        color: #6c757d;
        margin: 0.75rem 0;
        line-height: 1.4;
    }

    .card-list li {
        margin-bottom: 0.3rem;
    }

    .btn-cta {
        background: linear-gradient(135deg, #667eea, #764ba2);
        color: white;
        font-weight: 600;
        border-radius: 50px;
        padding: 0.5rem 1.2rem;
        transition: all 0.2s ease-in-out;
    }

    .btn-cta:hover {
        opacity: 0.95;
    }
</style>

<div class="container py-5">
    <div class="text-center mb-5">
        <h2 class="fw-bold text-white">🚀 Promote Available Products</h2>
        <p class="text-light">Pick from curated admin products to start earning commissions</p>
    </div>

    <div class="row row-cols-1 row-cols-md-3 g-4">
        <?php if ($product_query->num_rows > 0): ?>
            <?php while ($product = $product_query->fetch_assoc()): ?>
                <div class="col d-flex">
                    <div class="card card-equal w-100">
                        <img src="./uploads/<?= htmlspecialchars($product['image']) ?>" class="card-img-top" alt="<?= htmlspecialchars($product['product_name']) ?>">

                        <div class="card-body">
                            <h5 class="card-title">
                                <i class="fas fa-tag text-primary me-1"></i>
                                <?= htmlspecialchars($product['product_name']) ?>
                            </h5>

                            <p class="card-text">
                                <i class="fas fa-align-left text-muted me-1"></i>
                                <?= implode(' ', array_slice(explode(' ', htmlspecialchars($product['description'])), 0, 7)) ?>...
                            </p>

                            <ul class="list-unstyled card-list small">
                                <li><i class="fas fa-money-bill-wave text-success me-1"></i> $<?= number_format($product['amount']) ?></li>
                                <li><i class="fas fa-check-circle text-info me-1"></i> Bought: <?= $product['amount_bought'] ?? 0 ?></li>
                                <li><i class="fas fa-boxes text-warning me-1"></i> Left: <?= $product['amount_left'] ?? 0 ?></li>
                            </ul>

                            <a href="promote_product.php?product_id=<?= urlencode($product['product_id']) ?>" class="btn btn-cta mt-3 w-100">
                                <i class="fas fa-bullhorn me-1"></i> Promote This Product
                            </a>
                        </div>
                    </div>
                </div>
            <?php endwhile; ?>
        <?php else: ?>
            <div class="col-12 text-center text-white">
                <p>No available products to promote right now.</p>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php include "footer.php"; ?>
