<?php
// Ensure error reporting is enabled for debugging
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
// Include your database connection file
include_once("../_db.php");

// Check if the plan ID is provided in the URL
if(isset($_GET['id'])) {
    $id = $_GET['id'];

    // Fetch the details of the investment plan with the provided ID
    $sql = "SELECT * FROM plans WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();

    // Check if the plan exists
    if($result->num_rows > 0) {
        $plan = $result->fetch_assoc();
    } else {
        echo "Plan not found.";
        exit(); // Stop script execution if plan not found
    }
} else {
    echo "Plan ID not provided.";
    exit(); // Stop script execution if plan ID not provided
}

// Check if form is submitted
if(isset($_POST['btnSaveUpdate'])) {
    // Retrieve form data
    $plan_title = $_POST['plan_title'];
    $minimum = $_POST['minimum'];
    $maximum = $_POST['maximum'];
    $profit = $_POST['profit'];
    $roi = $_POST['roi'];
    $days = $_POST['days'];
    $description = $_POST['description'];
    
    // Check if a new image file is uploaded
    if($_FILES['image']['name']) {
        $image = $_FILES['image']['name'];
        $target_dir = "../uploads/";  // Set the target directory for image uploads
        $target_file = $target_dir . basename($image);

        // Move uploaded file to target directory
        if(move_uploaded_file($_FILES['image']['tmp_name'], $target_file)) {
            $image_url = $target_file;
        } else {
            echo "Error uploading image.";
            exit();
        }
    } else {
        // If no new image is uploaded, retain the old image URL
        $image_url = $plan['image'];
    }

    // Update investment plan details
    $sql = "UPDATE plans SET plan_title = ?, minimum = ?, maximum = ?, profit = ?, roi = ?, days = ?, description = ?, image = ? WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("sssssssss", $plan_title, $minimum, $maximum, $profit, $roi, $days, $description, $image_url, $id);

    if($stmt->execute()) {
        // Plan details updated successfully
        // Redirect back to the page where the modal was triggered (you may need to change this URL)
        header("Location: manage-plan.php");
        exit(); // Ensure script execution stops after redirection
    } else {
        // Error updating plan details
        echo "Error updating plan details: " . $conn->error;
    }

    // Close statement and connection
    $stmt->close();
    $conn->close();
}
?>

<?php
include 'head.php';
include 'header.php';
?>

<body class="skin-default fixed-layout">
    <div id="main-wrapper">
        <?php include 'sidebar.php'; ?>
        <div class="page-wrapper">
            <section>
                <div class="">
                    <?php include 'nav1.php'; ?>
                    <div class="container-fluid">
                        <div class="card">
                            <div class="card-header">
                                <!-- Optional message -->
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table">
                                        <tbody>
                                            <!-- HTML Form for updating plan -->
                                            <h1>Edit Investment Plan</h1>
                                            <form action="" method="post" enctype="multipart/form-data">
                                                <div>
                                                    <label for="plan_title">Plan Title:</label>
                                                    <input type="text" class="form-control" name="plan_title" value="<?php echo $plan['plan_title']; ?>" required>
                                                </div>
                                                <div>
                                                    <label for="minimum">Minimum:</label>
                                                    <input type="number" class="form-control" name="minimum" value="<?php echo $plan['minimum']; ?>" required>
                                                </div>
                                                <div>
                                                    <label for="maximum">Maximum:</label>
                                                    <input type="number" class="form-control" name="maximum" value="<?php echo $plan['maximum']; ?>" required>
                                                </div>
                                                <div>
                                                    <label for="profit">Profit:</label>
                                                    <input type="number" class="form-control" name="profit" value="<?php echo $plan['profit']; ?>" required>
                                                </div>
                                                <div>
                                                    <label for="roi">ROI:</label>
                                                    <input type="number" class="form-control" name="roi" value="<?php echo $plan['roi']; ?>" required>
                                                </div>
                                                <div>
                                                    <label for="days">Days:</label>
                                                    <input type="number" class="form-control mb-4" name="days" value="<?php echo $plan['days']; ?>" required>
                                                </div>
                                                <div>
                                                    <label for="description">Description:</label>
                                                    <textarea class="form-control mb-4" name="description" required><?php echo $plan['description']; ?></textarea>
                                                </div>
                                                <div>
                                                    <label for="image">Image:</label><br>
                                                    <img src="<?php echo $plan['image']; ?>" width="100" alt="Current Image"><br><br>
                                                    <input type="file" class="form-control" name="image">
                                                </div>
                                                <input type="submit" class="btn btn-success" name="btnSaveUpdate" value="Save Changes">
                                            </form>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
    <?php include 'footer.php'; ?>
</body>
</html>
