<?php
include 'head.php';
include 'header.php';
include_once("../_db.php");

$status = $message = '';

// Handle Product Edit/Add
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $product_id = $_POST['product_id'] ?? md5(uniqid());
    $product_name = $_POST['product_name'];
    $amount = $_POST['amount'];
    $description = $_POST['description'];

    $image_name = '';
    if (!empty($_FILES['image']['name'])) {
        $uploadDirectory = '../uploads/products/';
        if (!is_dir($uploadDirectory)) mkdir($uploadDirectory, 0755, true);

        $fileName = basename($_FILES['image']['name']);
        $targetPath = $uploadDirectory . time() . '-' . $fileName;

        if (move_uploaded_file($_FILES['image']['tmp_name'], $targetPath)) {
            $image_name = basename($targetPath);
        }
    }

    if (isset($_POST['editing']) && $_POST['editing'] === 'yes') {
        if ($image_name !== '') {
            $stmt = $conn->prepare("UPDATE products SET product_name=?, amount=?, description=?, image=? WHERE product_id=?");
            $stmt->bind_param("sdsss", $product_name, $amount, $description, $image_name, $product_id);
        } else {
            $stmt = $conn->prepare("UPDATE products SET product_name=?, amount=?, description=? WHERE product_id=?");
            $stmt->bind_param("sdss", $product_name, $amount, $description, $product_id);
        }
        $stmt->execute();
        $status = 'success';
        $message = 'Product updated successfully.';
    } else {
        if (empty($image_name)) {
            $status = 'error';
            $message = 'Image is required.';
        } else {
            $stmt = $conn->prepare("INSERT INTO products (product_id, product_name, amount, description, image) VALUES (?, ?, ?, ?, ?)");
            $stmt->bind_param("sssss", $product_id, $product_name, $amount, $description, $image_name);
            $stmt->execute();
            $status = 'success';
            $message = 'Product added successfully.';
        }
    }
}

include 'sidebar.php';
?>

<body class="skin-default fixed-layout">
    <div id="main-wrapper">
        <div class="page-wrapper">
            <div class="container-fluid">
                <?php include 'nav.php'; ?>

                <div class="container">
                    <?php if ($status): ?>
                        <div class="alert alert-<?= $status === 'success' ? 'success' : 'danger' ?>">
                            <?= htmlspecialchars($message) ?>
                        </div>
                    <?php endif; ?>

                    <div class="text-right my-3">
                        <button type="button" class="btn btn-success" data-toggle="modal" data-target="#productModal" onclick="clearForm()">
                            <i class="bi bi-plus"></i> Add Product
                        </button>
                    </div>
                </div>

                <!-- Product Modal -->
                <div class="container">
                    <div class="modal fade" id="productModal">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <form action="" method="POST" enctype="multipart/form-data">
                                    <div class="modal-header">
                                        <h4 class="modal-title">Product Form</h4>
                                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                                    </div>
                                    <div class="modal-body">
                                        <input type="hidden" name="product_id" id="product_id">
                                        <input type="hidden" name="editing" id="editing" value="no">
    
                                        <div class="form-group">
                                            <label>Product Name</label>
                                            <input type="text" name="product_name" id="product_name" class="form-control" required>
                                        </div>
                                        <div class="form-group">
                                            <label>Amount</label>
                                            <input type="text" name="amount" id="amount" class="form-control" required>
                                        </div>
                                        <div class="form-group">
                                            <label>Description</label>
                                            <textarea name="description" id="description" class="form-control" required></textarea>
                                        </div>
                                        <div class="form-group">
                                            <label>Image (optional for edit)</label>
                                            <input type="file" name="image" accept="image/png, image/jpeg, image/webp" class="form-control">
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="submit" class="btn btn-success">Save</button>
                                        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Display Products -->
                <div class="container card">
    <div class="card-body">
        <h4 class="card-title">Admin Products (Without User ID)</h4>
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Image</th>
                        <th>Name</th>
                        <th>Description</th>
                        <th>Amount</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php 
                    $result = $conn->query("SELECT * FROM products WHERE user_id IS NULL");
                    $count = 1;
                    while ($row = $result->fetch_assoc()):
                    ?>
                    <tr>
                        <td><?= $count++ ?></td>
                        <td><img src="../uploads/<?= htmlspecialchars($row['image']) ?>" height="60"></td>
                        <td><?= htmlspecialchars($row['product_name']) ?></td>
                        <td>
                            <?php
                                $desc_words = explode(' ', strip_tags($row['description']));
                                $short_desc = implode(' ', array_slice($desc_words, 0, 7));
                                echo htmlspecialchars($short_desc) . (count($desc_words) > 7 ? '...' : '');
                            ?>
                        </td>
                        <td>$<?= number_format($row['amount']) ?></td>
                        <td>
                            <button class="btn btn-warning btn-sm" 
                                onclick="editProduct(
                                    '<?= $row['product_id'] ?>',
                                    '<?= htmlspecialchars(addslashes($row['product_name'])) ?>',
                                    '<?= $row['amount'] ?>',
                                    `<?= htmlspecialchars(addslashes($row['description'])) ?>`
                                )">
                                Edit
                            </button>
                        </td>
                    </tr>
                    <?php endwhile; ?>
                    <?php if ($count == 1): ?>
                        <tr><td colspan="6">No products found.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>


            </div>
        </div>
    </div>

<script>
function editProduct(id, name, amount, description) {
    document.getElementById('product_id').value = id;
    document.getElementById('product_name').value = name;
    document.getElementById('amount').value = amount;
    document.getElementById('description').value = description;
    document.getElementById('editing').value = 'yes';
    $('#productModal').modal('show');
}

function clearForm() {
    document.getElementById('product_id').value = '';
    document.getElementById('product_name').value = '';
    document.getElementById('amount').value = '';
    document.getElementById('description').value = '';
    document.getElementById('editing').value = 'no';
}
</script>

<?php include 'footer.php'; ?>
</body>
