<?php 
include 'head.php';
include 'header.php';

// Include database connection file
include_once("../_db.php");

// Initialize variables
$status = $message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $bedrooms = $_POST['bedrooms'];
    $location = $_POST['location'];
    $baths = $_POST['baths'];
    $heights = $_POST['heights'];
    $description = $_POST['description'];
    $price = $_POST['price'];
    $state = $_POST['state'];
    $neighborhood = $_POST['neighborhood'];
    $agent = $_POST['agent'];
    $type = $_POST['type'];
    $country = $_POST['country'];
    $rental_id = md5(uniqid());

    // Check if all fields are filled
    if (empty($bedrooms) || empty($location) || empty($baths) || empty($heights) || empty($description) || empty($price) || empty($state) || empty($neighborhood) || empty($agent) || empty($type) || empty($country) || empty($_FILES['image']['name'][0])) {
        $status = 'error';
        $message = 'Please fill all fields';
    } else {
        // File upload handling
        $uploadDirectory = '../rental/';

        // Loop through each uploaded image
        foreach ($_FILES['image']['tmp_name'] as $key => $tmp_name) {
            $fileName = basename($_FILES['image']['name'][$key]);
            $targetPath = $uploadDirectory . $fileName;

            // Check if file already exists
            if (file_exists($targetPath)) {
                $status = 'error';
                $message = 'File already exists';
                break;
            } else {
                // Upload file
                if (!move_uploaded_file($_FILES['image']['tmp_name'][$key], $targetPath)) {
                    $status = 'error';
                    $message = 'Failed to upload file';
                    break;
                } else {
                    // Insert into database
                    $insertQuery = "INSERT INTO rentals (rental_id, bedroom_category, location, baths, heights, description, price, state, neighborhood, agent, type, country, nft_img) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                    $insertStmt = $conn->prepare($insertQuery);

                    // Check if prepare() was successful
                    if ($insertStmt) {
                        $insertStmt->bind_param("sssssssssssss", $rental_id, $bedrooms, $location, $baths, $heights, $description, $price, $state, $neighborhood, $agent, $type, $country, $fileName);
                        if ($insertStmt->execute()) {
                            $status = 'success';
                            $message = 'Rental added successfully';
                        } else {
                            $status = 'error';
                            $message = 'Failed to execute insert query: ' . $insertStmt->error;
                            break;
                        }
                    } else {
                        $status = 'error';
                        $message = 'Failed to prepare SQL statement: ' . $conn->error;
                        break;
                    }
                }
            }
        }
    }

    // Display status message
    if ($status) {
        echo '<div style="color: ' . ($status === 'success' ? 'green' : 'red') . ';">' . $message . '</div>';
    }
}
include 'sidebar.php';   
?>

<body class="skin-default fixed-layout">
    <div id="main-wrapper">
        <div class="page-wrapper">
            <div class="container-fluid">
                <?php include 'nav.php'; ?>
                <div class="container">
                    <div class="text-right my-3">
                        <button type="button" class="btn btn-success" data-toggle="modal" data-target="#myModal">
                            <i class="bi bi-plus"></i> Add Category
                        </button>
                    </div>
                </div>

                <!-- The Modal -->
                <div class="modal fade" id="myModal">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <!-- Modal Header -->
                            <div class="modal-header">
                                <h4 class="modal-title">Manage Category</h4>
                                <button type="button" class="close" data-dismiss="modal">&times;</button>
                            </div>
                            <!-- Modal body -->
                            <div class="modal-body">
                                <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post" class="add-product-form" enctype="multipart/form-data">
                                    <select name="bedrooms" class="form-control my-2">
                                        <option value="Studio">Studio</option>
                                        <option value="1">1 Bedroom</option>
                                        <option value="2">2 Bedrooms</option>
                                        <option value="3">3 Bedrooms</option>
                                    </select>

                                    <div class="form-group">
                                        <input type="text" name="location" placeholder="Enter rental location" class="form-control my-2" required>
                                    </div>
                                    
                                    <div class="form-group">
                                        <select name="baths" class="form-control my-2">
                                            <option value="1">1</option>
                                            <option value="1.5">1.5</option>
                                            <option value="2">2</option>
                                            <option value="2.5">2.5</option>
                                            <option value="3">3</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <input type="text" name="heights" placeholder="Enter rental apartment height" class="form-control my-2" required>
                                    </div>
                                    <div class="form-group">
                                        <textarea name="description" cols="30" rows="5" class="form-control my-2" placeholder="Enter rental description" required></textarea>
                                    </div>
                                    <div class="form-group">
                                        <input type="number" name="price" placeholder="Enter rental price" class="form-control my-2" required>
                                    </div>
                                    <div class="form-group">
                                        <input type="text" name="state" placeholder="Enter rental state" class="form-control my-2" required>
                                    </div>
                                    <div class="form-group">
                                        <input type="text" name="neighborhood" placeholder="Enter rental neighborhood" class="form-control my-2" required>
                                    </div>
                                    <div class="form-group">
                                        <input type="text" name="agent" placeholder="Enter agent" class="form-control my-2" required>
                                    </div>
                                    <div class="form-group">
                                        <select name="type" class="form-control my-2">
                                            <option value="For rent">For Rent</option>
                                            <option value="For Sale">For Sale</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <input type="text" name="country" placeholder="Enter country" class="form-control my-2" required>
                                    </div>
                                    <label for="image[]">Select Image:</label>
                                    <input type="file" name="image[]" id="image" accept="image/png, image/jpeg, image/webp" multiple required><br><br>

                                    <!-- Modal footer -->
                                    <div class="modal-footer">
                                        <button type="submit" name="add_rental" class="btn btn-success">Submit</button>
                                        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>

                <section>
                    <div class="d-flex justify-content-end align-items-center">
                        <div class="container-fluid">
                            <div class="card">
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table">
                                            <thead>
                                                <tr>
                                                    <th>#</th>
                                                    <th>Rental Image</th>
                                                    <th>Bedrooms</th>
                                                    <th>Location</th>
                                                    <th>Price</th>
                                                    <th>Action</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php 
                                                  $select_rentals = mysqli_query($conn, "SELECT * FROM rentals");
                                                  if (mysqli_num_rows($select_rentals) > 0) {
                                                      $num = 1;
                                                      while ($row = mysqli_fetch_assoc($select_rentals)) {
                                                ?>
                                                <tr>
                                                    <td><?php echo $num++; ?></td>
                                                    <td><img src="../rental/<?php echo $row['nft_img']; ?>" height="100" alt=""></td>
                                                    <td><?php echo htmlspecialchars($row['bedroom_category']); ?></td>
                                                    <td><?php echo htmlspecialchars($row['location']); ?></td>
                                                    <td>$<?php echo number_format($row['price']); ?>/mo</td>
                                                    <td>
                                                        <a href="rental-details.php?rental_id=<?php echo $row['rental_id']; ?>" class="btn btn-info btn-sm"><i class="bi bi-eye-fill" style="font-size: 20px;"></i></a>
                                                    </td>
                                                </tr>
                                                <?php 
                                                      }
                                                  } 
                                                ?> 
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </div>  
    <?php
    include 'footer.php';
    ?>
</body>
