<?php
include "./include/head.php";
include "./include/navbar.php";
include "sidebar.php";

if (!isset($_SESSION['userid'])) {
    header("Location: login.php");
    exit();
}

$userid = $_SESSION['userid'];
$product_id = $_GET['product_id'] ?? '';

if (empty($product_id)) {
    echo "<div class='container py-5'><div class='alert alert-danger'>No product selected for promotion.</div></div>";
    include "footer.php";
    exit();
}

// Fetch the selected product (only allow products not created by users)
$stmt = $conn->prepare("SELECT * FROM products WHERE product_id = ? AND user_id IS NULL");
$stmt->bind_param("s", $product_id);
$stmt->execute();
$product = $stmt->get_result()->fetch_assoc();

if (!$product) {
    echo "<div class='container py-5'><div class='alert alert-warning'>Product not found or not eligible for promotion.</div></div>";
    include "footer.php";
    exit();
}

// Set promotion fee = product amount
$promotion_fee = floatval($product['amount']);

// Fetch all wallet/payment methods
$wallets_result = $conn->query("SELECT * FROM wallets ORDER BY id ASC");
$wallets = [];
while ($row = $wallets_result->fetch_assoc()) {
    $wallets[$row['type']] = $row['address'];
}
?>

<!-- Bootstrap CSS -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-md-7">

            <div class="card border-0 shadow-sm">

                <!-- Flash Message -->
                <?php if (isset($_SESSION['flash_message'])): ?>
                    <?php $msg = $_SESSION['flash_message']; ?>
                    <div class="alert alert-<?= $msg['type'] ?> alert-dismissible fade show m-3" role="alert">
                        <?= $msg['text'] ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    <?php unset($_SESSION['flash_message']); ?>
                <?php endif; ?>

                <img src="../uploads/<?= htmlspecialchars($product['image']) ?>" class="card-img-top" style="height: 240px; object-fit: cover;">
                <div class="card-body">
                    <h4 class="fw-bold"><?= htmlspecialchars($product['product_name']) ?></h4>
                    <p class="text-muted"><?= nl2br(htmlspecialchars($product['description'])) ?></p>

                    <ul class="list-unstyled small">
                        <li><strong>Amount:</strong> $<?= number_format($product['amount']) ?></li>
                        <li><strong>Amount Bought:</strong> <?= $product['amount_bought'] ?? 0 ?></li>
                        <li><strong>Amount Left:</strong> <?= $product['amount_left'] ?? 0 ?></li>
                    </ul>

                    <hr>
                    <h5 class="text-danger">Promotion Fee: $<?= number_format($promotion_fee, 2) ?></h5>

                    <!-- Promotion form -->
                    <form action="process_promotion.php" method="POST">
                        <input type="hidden" name="product_id" value="<?= htmlspecialchars($product['product_id']) ?>">
                        <input type="hidden" name="promotion_fee" value="<?= htmlspecialchars($promotion_fee) ?>">

                        <!-- Payment Method Selection -->
                        <div class="mb-3">
                            <label for="payment_method" class="form-label fw-semibold">Select Payment Method</label>
                            <select class="form-select" id="payment_method" name="payment_method" required onchange="showWallet(this.value)">
                                <option value="">-- Choose Method --</option>
                                <?php foreach ($wallets as $type => $address): ?>
                                    <option value="<?= htmlspecialchars($type) ?>"><?= strtoupper($type) ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>

                        <!-- Wallet Address Display -->
                        <div class="mb-3" id="wallet_section" style="display:none;">
                            <label class="form-label fw-semibold">Wallet / Account Address</label>
                            <div class="input-group">
                                <input type="text" id="wallet_address" class="form-control" readonly>
                                <button type="button" class="btn btn-outline-secondary" onclick="copyWallet()">Copy</button>
                            </div>
                        </div>

                        <button type="submit" class="btn btn-success w-100 mt-3 rounded-pill">
                            Proceed to Pay & Promote
                        </button>
                    </form>
                </div>
            </div>

        </div>
    </div>
</div>

<!-- JS to handle wallet display and copy -->
<script>
    const wallets = <?= json_encode($wallets) ?>;

    function showWallet(method) {
        const section = document.getElementById("wallet_section");
        const input = document.getElementById("wallet_address");

        if (wallets[method]) {
            input.value = wallets[method];
            section.style.display = "block";
        } else {
            input.value = '';
            section.style.display = "none";
        }
    }

    function copyWallet() {
        const input = document.getElementById("wallet_address");
        input.select();
        input.setSelectionRange(0, 99999); 
        document.execCommand("copy");
        alert("✅ Wallet address copied!");
    }
</script>

<?php include "footer.php"; ?>
