<?php
session_start();
include "./include/head.php";
include "sidebar.php";
include "./include/navbar.php";

if (!isset($_SESSION['userid'])) {
    header("Location: login.php");
    exit();
}

$userid = $_SESSION['userid'];

if (!isset($_GET['product_id'])) {
    echo "<div class='alert alert-danger m-4'>No product selected.</div>";
    exit();
}

$product_id = $_GET['product_id'];

// Handle reply
if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $message = trim($_POST['message']);
    $image_name = "";

    // Handle image upload
    if (!empty($_FILES['image']['name'])) {
        $upload_dir = "../dashboard/uploads/";
        if (!is_dir($upload_dir)) mkdir($upload_dir, 0777, true);

        $image_name = time() . "_" . basename($_FILES["image"]["name"]);
        $target_file = $upload_dir . $image_name;
        move_uploaded_file($_FILES["image"]["tmp_name"], $target_file);
    }

    $stmt = $conn->prepare("INSERT INTO product_messages (product_id, sender_role, sender_id, message, image) VALUES (?, 'seller', ?, ?, ?)");
    $stmt->bind_param("ssss", $product_id, $userid, $message, $image_name);
    $stmt->execute();
}

// Fetch messages
$msg_stmt = $conn->prepare("SELECT * FROM product_messages WHERE product_id = ? ORDER BY sent_at ASC");
$msg_stmt->bind_param("s", $product_id);
$msg_stmt->execute();
$messages = $msg_stmt->get_result();
?>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" integrity="sha512-R8+qFujdfZ+W7MqGQ+dCq2aEnI2OySg4InbkU8bLQ+1cMBFgE7ZoD3V9yzOmlUEDd9l0TzR2Zu8hF7FcrfZNLw==" crossorigin="anonymous" referrerpolicy="no-referrer" />

<style>
    .bg-primary {
        background-color: #6c63ff !important;
    }

    .shadow-sm {
        box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075) !important;
    }
</style>
<div class="container py-5">
    <h4 class="fw-bold mb-4 text-white">💬 Project Conversations</h4>

    <style>
    .chat-wrapper {
        background-color: #e5ddd5;
        border-radius: 15px;
        height: 480px;
        padding: 20px;
        overflow-y: auto;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
    }

    .chat-message {
        display: flex;
        margin-bottom: 12px;
    }

    .chat-message.right {
        justify-content: flex-end;
    }

    .chat-message.left {
        justify-content: flex-start;
    }

    .message-bubble {
        max-width: 75%;
        padding: 12px 16px;
        border-radius: 18px;
        font-size: 15px;
        line-height: 1.4;
        position: relative;
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
        word-wrap: break-word;
    }

    .seller-message {
        background-color: #ffffff;
        color: #333;
        border-top-left-radius: 0;
    }

    .admin-message {
        background-color: #dcf8c6;
        color: #000;
        border-top-right-radius: 0;
    }

    .message-img {
    max-width: 220px;
    max-height: 200px;
    height: auto;
    margin-top: 10px;
    border-radius: 10px;
    object-fit: cover;
    display: block;
}


    .message-time {
        font-size: 11px;
        color: #555;
        margin-top: 5px;
        text-align: right;
    }

    @media (max-width: 768px) {
        .message-bubble {
            max-width: 100%;
        }
    }
</style>
<div class="chat-card bg-white p-3 rounded shadow">
<div class="chat-wrapper mb-4" id="chat-messages"> <!-- ✅ Add ID for JavaScript to target -->
    <?php if ($messages->num_rows > 0) : ?>
        <?php while ($msg = $messages->fetch_assoc()) : ?>
            <?php
            $isSeller = $msg['sender_role'] === 'seller';
            $sideClass = $isSeller ? 'right' : 'left';
            $bubbleClass = $isSeller ? 'admin-message' : 'seller-message';
            ?>
            <div class="chat-message <?php echo $sideClass; ?>">
                <div class="message-bubble <?php echo $bubbleClass; ?>">
                    <?php if (!empty($msg['message'])) : ?>
                        <div><?php echo nl2br(htmlspecialchars($msg['message'])); ?></div>
                    <?php endif; ?>

                    <?php if (!empty($msg['image'])) : ?>
                        <img src="../dashboard/uploads/<?php echo htmlspecialchars($msg['image']); ?>" alt="Image" class="message-img">
                    <?php endif; ?>

                    <div class="message-time">
                        <?php echo date("M d, Y h:i A", strtotime($msg['sent_at'])); ?>
                    </div>
                </div>
            </div>
        <?php endwhile; ?>
    <?php else : ?>
        <p class="text-center text-muted">No messages yet for this project.</p>
    <?php endif; ?>
</div>


    <!-- Font Awesome link (MUST BE INCLUDED) -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" integrity="sha512-R8+qFujdfZ+W7MqGQ+dCq2aEnI2OySg4InbkU8bLQ+1cMBFgE7ZoD3V9yzOmlUEDd9l0TzR2Zu8hF7FcrfZNLw==" crossorigin="anonymous" referrerpolicy="no-referrer" />

<!-- Add Bootstrap Icons CDN -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">

<form method="POST"  enctype="multipart/form-data" class="chat-input-form">
    <style>
        .chat-input-form {
            display: flex;
            align-items: center;
            gap: 10px;
            background-color: #fff;
            border: 1px solid #ddd;
            border-radius: 30px;
            padding: 10px 15px;
            margin-top: 10px;
        }

        .chat-input-form textarea {
            resize: none;
            border: none;
            flex: 1;
            background-color: #f0f0f0;
            border-radius: 20px;
            padding: 10px 15px;
            font-size: 14px;
            height: 40px;
            line-height: 1.2;
        }

        .chat-input-form input[type="file"] {
            display: none;
        }

        .file-label {
            cursor: pointer;
            font-size: 20px;
            color: #6c757d;
            display: flex;
            align-items: center;
        }

        .chat-send-btn {
            background-color: #25D366;
            color: white;
            border: none;
            padding: 10px 12px;
            border-radius: 50%;
            font-size: 18px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .chat-send-btn:hover {
            background-color: #20b858;
        }
    </style>

    <!-- Paperclip icon for image upload -->
    <label for="chat-image" class="file-label" title="Attach image">
        <i class="bi bi-paperclip"></i>
    </label>
    <input type="file" name="image" id="chat-image" accept="image/*">

    <!-- Message box -->
    <textarea name="message" rows="1" placeholder="Type a message..." ></textarea>

    <!-- Send icon -->
    <button type="submit" class="chat-send-btn" title="Send">
        <i class="bi bi-send-fill"></i>
    </button>
</form>




</div>

</div>
<script>
document.querySelector(".chat-input-form").addEventListener("submit", function(e) {
    e.preventDefault();

    const form = e.target;
    const formData = new FormData(form);
    formData.append("product_id", "<?php echo $product_id; ?>");

    fetch("send-message.php", {
        method: "POST",
        body: formData
    })
    .then(res => res.text())
    .then(res => {
        if (res.trim() === "success") {
            form.reset();
            loadMessages();
        } else {
            console.error("Failed to send message:", res);
        }
    })
    .catch(err => console.error("Fetch error:", err));
});

function loadMessages() {
    fetch("load-messages.php?product_id=<?php echo $product_id; ?>")
    .then(res => res.text())
    .then(html => {
        const chatBox = document.getElementById("chat-messages");
        chatBox.innerHTML = html;
        chatBox.scrollTop = chatBox.scrollHeight;
    })
    .catch(err => console.error("Load error:", err));
}

// ✅ Load messages initially
loadMessages();

// ✅ Keep polling every 5 seconds
setInterval(loadMessages, 5000);
</script>

<?php include "footer.php"; ?>