<?php
session_start();
require_once '../_db.php'; // adjust path if needed

header('Content-Type: application/json');

if (!isset($_GET['userid']) || empty($_GET['userid'])) {
    echo json_encode([]);
    exit;
}

$userid = $_GET['userid'];

// Fetch only promoted products belonging to the user
$stmt = $conn->prepare("
    SELECT p.product_id, p.product_name
    FROM product_promotions pr
    INNER JOIN products p ON pr.product_id = p.product_id
    WHERE pr.userid = ?
    ORDER BY p.product_name ASC
");
$stmt->bind_param("s", $userid);
$stmt->execute();
$result = $stmt->get_result();

$products = [];
while ($row = $result->fetch_assoc()) {
    $products[] = [
        'product_id'   => $row['product_id'],
        'product_name' => $row['product_name']
    ];
}

echo json_encode($products);
