<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
include 'head.php';
include 'header.php';
?>

<body class="skin-default fixed-layout">
<div id="main-wrapper">

<?php 
include 'sidebar.php';
?>

<div class="page-wrapper">
    <section>
        <div class="">
            <?php include 'nav1.php'; ?>

            <div class="container-fluid">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">📦 Manage Program Subscriptions</h4>
                        <?php echo isset($_SESSION['mgs']) ? $_SESSION['mgs'] : ""; ?>  
                    </div>

                    <div class="card-body">
                        <!-- Tabs Navigation -->
                        <ul class="nav nav-tabs" id="programTabs" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="pending-tab" data-bs-toggle="tab" data-bs-target="#pending" type="button" role="tab">Pending</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="approved-tab" data-bs-toggle="tab" data-bs-target="#approved" type="button" role="tab">Approved</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="rejected-tab" data-bs-toggle="tab" data-bs-target="#rejected" type="button" role="tab">Rejected</button>
                            </li>
                        </ul>

                        <div class="tab-content pt-3" id="programTabsContent">
                            <!-- PENDING TAB -->
                            <div class="tab-pane fade show active" id="pending" role="tabpanel" aria-labelledby="pending-tab">
                                <?php
                                $pending = $conn->query("SELECT ps.*, ul.userid AS user_id, p.program_name 
                                    FROM program_subscriptions ps
                                    JOIN user_login ul ON ps.userid = ul.userid
                                    JOIN programs p ON ps.program_id = p.id
                                    WHERE ps.status = 'pending'
                                    ORDER BY ps.created_at DESC");
                                ?>
                                <div class="table-responsive">
                                    <table class="table table-bordered align-middle">
                                        <thead class="table-light">
                                            <tr>
                                                <th>#</th>
                                                <th>Date</th>
                                                <th>User ID</th>
                                                <th>Program</th>
                                                <th>Amount ($)</th>
                                                <th>Wallet Type</th>
                                                <th>Transaction ID</th>
                                                <th>ROI (%)</th>
                                                <th>Days</th>
                                                <th>Status</th>
                                                <th>Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            if ($pending && $pending->num_rows > 0) {
                                                $num = 1;
                                                while ($row = $pending->fetch_assoc()) { ?>
                                                    <tr>
                                                        <td><?php echo $num++; ?></td>
                                                        <td><?php echo $row['created_at']; ?></td>
                                                        <td><?php echo $row['userid']; ?></td>
                                                        <td><?php echo htmlspecialchars($row['program_name']); ?></td>
                                                        <td>$<?php echo number_format($row['amount'], 2); ?></td>
                                                        <td><?php echo htmlspecialchars($row['wallet_type']); ?></td>
                                                        <td><?php echo htmlspecialchars($row['transaction_id']); ?></td>
                                                        <td><?php echo $row['roi']; ?>%</td>
                                                        <td><?php echo $row['duration_days']; ?></td>
                                                        <td><span class="badge bg-warning text-dark">Pending</span></td>
                                                        <td>
                                                            <a href="approve_program.php?id=<?php echo $row['id']; ?>" class="btn btn-success btn-sm">Approve</a>
                                                            <a href="reject_program.php?id=<?php echo $row['id']; ?>" class="btn btn-danger btn-sm">Reject</a>
                                                        </td>
                                                    </tr>
                                                <?php }
                                            } else {
                                                echo "<tr><td colspan='11' class='text-center text-muted'>No pending subscriptions.</td></tr>";
                                            }
                                            ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>

                            <!-- APPROVED TAB -->
                            <div class="tab-pane fade" id="approved" role="tabpanel" aria-labelledby="approved-tab">
                                <?php
                                $approved = $conn->query("SELECT ps.*, ul.userid AS user_id, p.program_name 
                                    FROM program_subscriptions ps
                                    JOIN user_login ul ON ps.userid = ul.userid
                                    JOIN programs p ON ps.program_id = p.id
                                    WHERE ps.status = 'approved'
                                    ORDER BY ps.created_at DESC");
                                ?>
                                <div class="table-responsive">
                                    <table class="table table-bordered align-middle">
                                        <thead class="table-light">
                                            <tr>
                                                <th>#</th>
                                                <th>Date</th>
                                                <th>User ID</th>
                                                <th>Program</th>
                                                <th>Amount ($)</th>
                                                <th>Wallet Type</th>
                                                <th>Transaction ID</th>
                                                <th>ROI (%)</th>
                                                <th>Days</th>
                                                <th>Status</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            if ($approved && $approved->num_rows > 0) {
                                                $num = 1;
                                                while ($row = $approved->fetch_assoc()) { ?>
                                                    <tr>
                                                        <td><?php echo $num++; ?></td>
                                                        <td><?php echo $row['created_at']; ?></td>
                                                        <td><?php echo $row['userid']; ?></td>
                                                        <td><?php echo htmlspecialchars($row['program_name']); ?></td>
                                                        <td>$<?php echo number_format($row['amount'], 2); ?></td>
                                                        <td><?php echo htmlspecialchars($row['wallet_type']); ?></td>
                                                        <td><?php echo htmlspecialchars($row['transaction_id']); ?></td>
                                                        <td><?php echo $row['roi']; ?>%</td>
                                                        <td><?php echo $row['duration_days']; ?></td>
                                                        <td><span class="badge bg-success">Approved</span></td>
                                                    </tr>
                                                <?php }
                                            } else {
                                                echo "<tr><td colspan='10' class='text-center text-muted'>No approved subscriptions.</td></tr>";
                                            }
                                            ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>

                            <!-- REJECTED TAB -->
                            <div class="tab-pane fade" id="rejected" role="tabpanel" aria-labelledby="rejected-tab">
                                <?php
                                $rejected = $conn->query("SELECT ps.*, ul.userid AS user_id, p.program_name 
                                    FROM program_subscriptions ps
                                    JOIN user_login ul ON ps.userid = ul.userid
                                    JOIN programs p ON ps.program_id = p.id
                                    WHERE ps.status = 'rejected'
                                    ORDER BY ps.created_at DESC");
                                ?>
                                <div class="table-responsive">
                                    <table class="table table-bordered align-middle">
                                        <thead class="table-light">
                                            <tr>
                                                <th>#</th>
                                                <th>Date</th>
                                                <th>User ID</th>
                                                <th>Program</th>
                                                <th>Amount ($)</th>
                                                <th>Wallet Type</th>
                                                <th>Transaction ID</th>
                                                <th>ROI (%)</th>
                                                <th>Days</th>
                                                <th>Status</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            if ($rejected && $rejected->num_rows > 0) {
                                                $num = 1;
                                                while ($row = $rejected->fetch_assoc()) { ?>
                                                    <tr>
                                                        <td><?php echo $num++; ?></td>
                                                        <td><?php echo $row['created_at']; ?></td>
                                                        <td><?php echo $row['userid']; ?></td>
                                                        <td><?php echo htmlspecialchars($row['program_name']); ?></td>
                                                        <td>$<?php echo number_format($row['amount'], 2); ?></td>
                                                        <td><?php echo htmlspecialchars($row['wallet_type']); ?></td>
                                                        <td><?php echo htmlspecialchars($row['transaction_id']); ?></td>
                                                        <td><?php echo $row['roi']; ?>%</td>
                                                        <td><?php echo $row['duration_days']; ?></td>
                                                        <td><span class="badge bg-danger">Rejected</span></td>
                                                    </tr>
                                                <?php }
                                            } else {
                                                echo "<tr><td colspan='10' class='text-center text-muted'>No rejected subscriptions.</td></tr>";
                                            }
                                            ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>

                        </div> <!-- /tab-content -->
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
</div>

<?php include 'footer.php'; ?>
</body>
</html>
