<?php
include "./include/_db.php"; // adjust path if needed
session_start();

header('Content-Type: application/json');

if (!isset($_SESSION['userid'])) {
    echo json_encode(["status" => "error", "message" => "Please log in first."]);
    exit();
}

$conn = $conn ?? new mysqli("localhost", "root", "", "your_database_name"); // adjust if not included
if ($conn->connect_error) {
    echo json_encode(["status" => "error", "message" => "Database connection failed."]);
    exit();
}

$userid = $_SESSION['userid'];
$program_id = intval($_POST['program_id']);
$amount = floatval($_POST['amount']);
$wallet_type = mysqli_real_escape_string($conn, $_POST['wallet_type']);
$wallet_address = mysqli_real_escape_string($conn, $_POST['wallet_address']);
$transaction_id = mysqli_real_escape_string($conn, $_POST['transaction_id']);

if (!$program_id || !$amount || !$wallet_type || !$wallet_address || !$transaction_id) {
    echo json_encode(["status" => "error", "message" => "Please fill in all required fields."]);
    exit();
}

// Fetch program info
$program = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM programs WHERE id='$program_id' LIMIT 1"));
if (!$program) {
    echo json_encode(["status" => "error", "message" => "Invalid program selected."]);
    exit();
}

if ($amount < $program['min_amount'] || $amount > $program['max_amount']) {
    echo json_encode([
        "status" => "error",
        "message" => "Amount must be between $" . number_format($program['min_amount'], 2) . " and $" . number_format($program['max_amount'], 2)
    ]);
    exit();
}

$stmt = $conn->prepare("INSERT INTO program_subscriptions (userid, program_id, amount, wallet_type, wallet_address_input, transaction_id, roi, duration_days, status, created_at)
VALUES (?, ?, ?, ?, ?, ?, ?, ?, 'pending', NOW())");
$stmt->bind_param("sidsssii", $userid, $program_id, $amount, $wallet_type, $wallet_address, $transaction_id, $program['roi'], $program['duration_days']);

if ($stmt->execute()) {
    echo json_encode(["status" => "success", "message" => "✅ Subscription submitted successfully. We’ll verify your transaction shortly."]);
} else {
    echo json_encode(["status" => "error", "message" => "❌ Failed to process subscription."]);
}
$stmt->close();
?>
