<?php
include "./include/head.php";

$product_id = $_GET['product_id'] ?? '';

if (empty($product_id)) {
    echo "<p class='text-danger'>No product selected</p>";
    exit();
}

$stmt = $conn->prepare("SELECT * FROM product_messages WHERE product_id = ? ORDER BY sent_at ASC");
$stmt->bind_param("s", $product_id);
$stmt->execute();
$messages = $stmt->get_result();

while ($msg = $messages->fetch_assoc()) {
    $isSeller = $msg['sender_role'] === 'seller';
    $sideClass = $isSeller ? 'right' : 'left';
    $bubbleClass = $isSeller ? 'admin-message' : 'seller-message';

    echo '<div class="chat-message ' . $sideClass . '">';
    echo '<div class="message-bubble ' . $bubbleClass . '">';
    if (!empty($msg['message'])) {
        echo nl2br(htmlspecialchars($msg['message']));
    }
    if (!empty($msg['image'])) {
        echo '<img src="../dashboard/uploads/' . htmlspecialchars($msg['image']) . '" class="message-img" />';
    }
    echo '<div class="message-time">' . date("M d, Y h:i A", strtotime($msg['sent_at'])) . '</div>';
    echo '</div></div>';
}

