<?php
include "./include/head.php";
include "sidebar.php";
include "./include/navbar.php";

if (!isset($_SESSION['userid'])) {
    header("Location: login.php");
    exit();
}
$userid = $_SESSION['userid'];

$message = ""; // feedback message

// ==============================
// Handle approve/decline actions
// ==============================
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['request_id'], $_POST['action'])) {
    $request_id = intval($_POST['request_id']);
    $action     = ($_POST['action'] === 'approve') ? 'approved' : 'rejected';

    $stmt = $conn->prepare("UPDATE product_sales_requests SET status = ? WHERE id = ? AND userid = ?");
    $stmt->bind_param("sis", $action, $request_id, $userid);

    if ($stmt->execute()) {
        if ($action === "approved") {
            $message = "<div class='alert alert-success alert-dismissible fade show' role='alert'>
                          ✅ Request Approved Successfully!
                          <button type='button' class='btn-close' data-bs-dismiss='alert' aria-label='Close'></button>
                        </div>";
        } else {
            $message = "<div class='alert alert-danger alert-dismissible fade show' role='alert'>
                          ❌ Request Declined!
                          <button type='button' class='btn-close' data-bs-dismiss='alert' aria-label='Close'></button>
                        </div>";
        }
    } else {
        $message = "<div class='alert alert-warning alert-dismissible fade show' role='alert'>
                      ⚠️ Something went wrong. Please try again.
                      <button type='button' class='btn-close' data-bs-dismiss='alert' aria-label='Close'></button>
                    </div>";
    }
    $stmt->close();
}

// ==============================
// Fetch requests for this user
// ==============================
$stmt = $conn->prepare("
    SELECT r.id, r.product_id, p.product_name, r.sale_amount, r.notes, 
           r.status, r.request_date, r.requested_by
    FROM product_sales_requests r
    INNER JOIN products p ON r.product_id = p.product_id
    INNER JOIN product_promotions pr ON r.product_id = pr.product_id
    WHERE r.userid = ?
      AND pr.userid = ?
    ORDER BY r.request_date DESC
");
$stmt->bind_param("ss", $userid, $userid);
$stmt->execute();
$sales_requests = $stmt->get_result();
?>

<!-- Bootstrap CSS -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

<div class="container-fluid px-4 py-5">
    <!-- Show feedback alerts -->
    <?php if (!empty($message)) echo $message; ?>

    <!-- Sales Requests Section -->
    <div class="row mt-5">
        <div class="col-12">
            <h4 class="fw-bold mb-3 text-white">📊 Sales Requests Sent To You</h4>
            <div class="card shadow-sm rounded-4">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped align-middle">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Product</th>
                                    <th>Sale Amount</th>
                                    <th>Notes</th>
                                    <th>Requested By (Admin)</th>
                                    <th>Status</th>
                                    <th>Requested At</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                if ($sales_requests->num_rows > 0) {
                                    $i = 1;
                                    while ($r = $sales_requests->fetch_assoc()) {
                                        echo "<tr>
                                            <td>{$i}</td>
                                            <td>" . htmlspecialchars($r['product_name']) . "</td>
                                            <td>$" . number_format($r['sale_amount'], 2) . "</td>
                                            <td>" . (!empty($r['notes']) ? htmlspecialchars($r['notes']) : "<em class='text-muted'>No notes</em>") . "</td>
                                            <td>" . htmlspecialchars($r['requested_by']) . "</td>
                                            <td><span class='badge bg-" . ($r['status'] == 'pending' ? "warning" : ($r['status'] == 'approved' ? "success" : "danger")) . "'>" . ucfirst($r['status']) . "</span></td>
                                            
                                            <td>
                                                <span class='local-time' data-utc='" . date('c', strtotime($r['request_date'])) . "'>
                                                    " . date("M d, Y h:i A", strtotime($r['request_date'])) . " UTC
                                                </span>
                                            </td>
                                            
                                            <td>";
                                        
                                        if ($r['status'] === 'pending') {
                                            echo "
                                            <form method='POST' class='d-inline'>
                                                <input type='hidden' name='request_id' value='{$r['id']}'>
                                                <button type='submit' name='action' value='approve' class='btn btn-success btn-sm'>Approve</button>
                                            </form>
                                            <form method='POST' class='d-inline'>
                                                <input type='hidden' name='request_id' value='{$r['id']}'>
                                                <button type='submit' name='action' value='decline' class='btn btn-danger btn-sm'>Decline</button>
                                            </form>";
                                        } else {
                                            echo "<em class='text-muted'>No action</em>";
                                        }

                                        echo "</td></tr>";
                                        $i++;
                                    }
                                } else {
                                    echo "<tr><td colspan='8' class='text-center text-muted'>😕 No sales requests sent to you yet.</td></tr>";
                                }
                                ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php include "footer.php"; ?>
</div>