<?php
session_start();
?>
<!DOCTYPE html>
<html lang="en" data-theme="Theme Type" data-sidebar-behaviour="fixed" data-navigation-color="inverted" data-is-fluid="true">

<meta http-equiv="content-type" content="text/html;charset=UTF-8">

<head>
    <meta charset="utf-8">
    
    <meta name="csrf-token" content="YCF8mcIMF66lceuaNiSbJKZSHh22B4uZpVxwMdGX">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta content="" name="author">
    <!-- Theme CSS -->
    <meta property="og:image" content="https://extrodigitalpro.com/storage/app/public/photos/r42z8xiczF5sbsiRayEiQc8Lmb1qt15QwdzoH5Yz.png ">
    <link rel="stylesheet" href="themes/dashly/assets/css/theme.bundle.css" id="stylesheetLTR">
    <link rel="stylesheet" href="themes/dashly/assets/css/theme.rtl.bundle.css" id="stylesheetRTL">
    <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin="">
    <link rel="preload" as="style" href="css2?family=Open+Sans:wght@300;400;600;700;800&amp;display=swap">
    <link rel="stylesheet" media="print" onload="this.onload=null;this.removeAttribute('media');" href="css2?family=Open+Sans:wght@300;400;600;700;800&amp;display=swap">
        <link rel="stylesheet" href="themes/dashly/assets/ext/font/bootstrap-icons.css">
        
     <!-- Include SweetAlert CSS and JS via CDN -->
     <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@10.16.3/dist/sweetalert2.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10.16.3/dist/sweetalert2.all.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/7.2.0/sweetalert2.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/7.2.0/sweetalert2.all.min.js"></script>
    <!-- no-JS fallback -->
    <noscript>
        <link rel="stylesheet" href="css2?family=Open+Sans:wght@300;400;600;700;800&amp;display=swap">
    </noscript>
    <script>
        // Theme switcher
        let themeSwitcher = document.getElementById('themeSwitcher');

        const getPreferredTheme = () => {
            if (localStorage.getItem('theme') != null) {
                return localStorage.getItem('theme');
            }

            return document.documentElement.dataset.theme;
        };

        const setTheme = function(theme) {
            if (theme === 'auto' && window.matchMedia('(prefers-color-scheme: dark)').matches) {
                document.documentElement.dataset.theme = window.matchMedia('(prefers-color-scheme: dark)').matches ?
                    'dark' : 'light';
            } else {
                document.documentElement.dataset.theme = theme;
            }

            localStorage.setItem('theme', theme);
        };

        const showActiveTheme = theme => {
            const activeBtn = document.querySelector(`[data-theme-value="${theme}"]`);

            document.querySelectorAll('[data-theme-value]').forEach(element => {
                element.classList.remove('active');
            });

            activeBtn && activeBtn.classList.add('active');

            // Set button if demo mode is enabled
            document.querySelectorAll('[data-theme-control="theme"]').forEach(element => {
                if (element.value == theme) {
                    element.checked = true;
                }
            });
        };

        function reloadPage() {
            window.location = window.location.pathname;
        }


        setTheme(getPreferredTheme());

        if (typeof themeSwitcher != 'undefined') {
            window.matchMedia('(prefers-color-scheme: dark)').addEventListener('change', e => {
                if (localStorage.getItem('theme') != null) {
                    if (localStorage.getItem('theme') == 'auto') {
                        reloadPage();
                    }
                }
            });

            window.addEventListener('load', () => {
                showActiveTheme(getPreferredTheme());

                document.querySelectorAll('[data-theme-value]').forEach(element => {
                    element.addEventListener('click', () => {
                        const theme = element.getAttribute('data-theme-value');

                        localStorage.setItem('theme', theme);
                        reloadPage();
                    })
                })
            });
        }
    </script>
    <!-- Favicon -->
    <link rel="icon" href="storage/app/public/photos/QU2i9eb3W6MbSPIruj5EP4wvld0n5Z2Q7Yr5i9k6.png" sizes="any">

    <!-- Demo script -->
    <script>
        var themeConfig = {
            theme: JSON.parse('"light"'),
            isRTL: JSON.parse('false'),
            isFluid: JSON.parse('true'),
            sidebarBehaviour: JSON.parse('"fixed"'),
            navigationColor: JSON.parse('"inverted"')
        };

        var isRTL = localStorage.getItem('isRTL') === 'true',
            isFluid = localStorage.getItem('isFluid') === 'true',
            theme = localStorage.getItem('theme'),
            sidebarSizing = localStorage.getItem('sidebarSizing'),
            linkLTR = document.getElementById('stylesheetLTR'),
            linkRTL = document.getElementById('stylesheetRTL'),
            html = document.documentElement;

        if (isRTL) {
            linkLTR.setAttribute('disabled', '');
            linkRTL.removeAttribute('disabled');
            html.setAttribute('dir', 'rtl');
        } else {
            linkRTL.setAttribute('disabled', '');
            linkLTR.removeAttribute('disabled');
            html.removeAttribute('dir');
        }
    </script>
    <!-- Page Title -->
    <title>Sign up | Choicydigitals</title>
    <script src="themes/dashly/assets/ext/dist/alpine.min.js" defer=""></script>
</head>

<body>

    <!-- THEME CONFIGURATION -->
    <script>
        let themeAttrs = document.documentElement.dataset;

        for (let attr in themeAttrs) {
            if (localStorage.getItem(attr) != null) {
                document.documentElement.dataset[attr] = localStorage.getItem(attr);

                if (theme === 'auto') {
                    document.documentElement.dataset.theme = window.matchMedia('(prefers-color-scheme: dark)').matches ?
                        'dark' : 'light';

                    window.matchMedia('(prefers-color-scheme: dark)').addEventListener('change', e => {
                        e.matches ? document.documentElement.dataset.theme = 'dark' : document.documentElement
                            .dataset.theme = 'light';
                    });
                }
            }
        }
    </script>
    <!-- MAIN CONTENT -->
    <main class="container">
            <div class="row align-items-center justify-content-center">
        <div class="col-md-7 col-lg-6 px-lg-4 px-xl-8 d-flex flex-column vh-100 py-6">
        <a class="uk-logo" href="index.php">
                                <!-- <img src="storage/app/public/photos/logo.jpg"  alt=""> -->
                                <img class="in-offset-top-10" src="storage/app/public/photos/logo.jpg" data-src="storage/app/public/photos/logo.jpg" alt="logo" width="330" height="36" data-uk-img="">
                            </a>

            <div>
                <!-- Title -->
                <h1 class="mb-2">
                    Free Sign Up
                </h1>

                <!-- Subtitle -->
                <p class="text-secondary">
                    Don't have an account? Create your account, it takes less than a minute
                </p>
<?php
if (isset($_GET['status']) && isset($_GET['message'])) {
    $status = $_GET['status'];
    $message = urldecode($_GET['message']);

    echo '<div class="alert alert-' . ($status === 'success' ? 'success' : 'danger') . '">' . htmlspecialchars($message) . '</div>';
}
?>

                <!-- Form -->
                <form id="form1" class="form-group flex-wrap" method="POST" action="./authenticator/signin-process.php">
                <div class="row g-3">
                    <div class="col-md-6">
                        <div class="form-floating">
                            <input type="text" id="" name="full_name" placeholder="Your Full name" class="form-control">
                            <label for="">YOUR FULL NAME</label>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-floating">
                            <input type="email" id="exampleInputName" name="email" placeholder="Your email address" class="form-control">
                            <label for="">YOUR E-MAIL ADDRESS<span class="imp">*</span>:</label>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-floating">
                            <input type="text" id="" name="phone_number" placeholder="Your phone Number" class="form-control">
                            <label for="">YOUR phone Number<span class="imp">*</span>:</label>
                        </div>
                    </div>
                    

                    <div class="col-md-6">
                        <div class="form-floating">
                            <input type="password" id="inputPassword1" name="password" placeholder="Enter your password" class="form-control" aria-describedby="passwordHelpBlock">
                            <label for="">ENTER PASSWORD<span class="imp">*</span>:</label>
                        </div>
                    </div>

                    <div class="col-md-12">
                        <div class="form-floating">
                            <input type="password" id="inputPassword2" name="cpassword" placeholder="Confirm your password" class="form-control" aria-describedby="passwordHelpBlock">
                            <label for="">CONFIRM PASSWORD<span class="imp">*</span>:</label>
                        </div>
                    </div>

                   
                    
                      
                    <div class="chekBl col-12">
                        <div class="chek">
                            <input type="checkbox" id="ck1" name="agree" value="1">
                            <label for="ck1">I agree with <a href="#" target="_blank">Terms and conditions</a></label>
                        </div>
                    </div>
                    <label class="py-3 d-flex flex-wrap justify-content-between">
                            <div>
                                <label for="ck1">Have an account,<a href="login.php" target="_blank"> login here?</a></label>
                                <!-- <a href="login.php" class="text-primary fw-medium text-decoration-none"> Have an account, login here?</a> -->
                            </div>

                            <div id="passwordHelpBlock" class="form-text ">
                                <!-- <a href="#" class="text-primary fw-medium"> Lost Your Password?</a> -->
                                <label for="ck1"><a href="#" target="_blank"> Lost Your Password?</a></label>

                            </div>
                        </label>
                    
                </div>
                <!-- Google reCAPTCHA -->
    <div class="mb-3">
        <!--<div class="g-recaptcha" data-sitekey="6LdEfusqAAAAACD0F8WnZ1NnH8TlJI04JYoZlsC6"></div>-->
    </div>
                <button type="submit" id="submit-btn" class="chy-pr-btn-1 tx-button mt-4 fadeInLeft btn-success">Register Now
        <span class="icon">
            <i aria-hidden="true" class="flaticon-straight-right-arrow"></i>       
        </span>
    </button>
</form>
                         
<!-- Include reCAPTCHA Script -->
<!-- <script src="https://www.google.com/recaptcha/api.js" async defer></script>-->
                            </div>

            <div class="mt-auto">
                <!-- Link -->
                <small class="mb-0 text-muted">
                    Already registered? <a href="login.php" class="fw-semibold">Login</a>
                </small>
            </div>
        </div>

        <div class="col-md-5 col-lg-6 d-none d-lg-block">
            <!-- Image -->
            <div class="bg-size-cover bg-position-center bg-repeat-no-repeat overlay overlay-dark overlay-50 vh-100 me-n4" style="background-image: url(themes/dashly/assets/images/covers/sign-up-cover.jpg);"></div>
        </div>
    </div> <!-- / .row -->
        
    </main> <!-- / main -->

    <!-- JAVASCRIPT-->
    <!-- Theme JS -->
    <script src="themes/dashly/assets/js/theme.bundle.js"></script>
            <script type="text/javascript" src="translate_a/element.js?cb=googleTranslateElementInit">
        </script>

        <script type="text/javascript">
            function googleTranslateElementInit() {
                new google.translate.TranslateElement({
                    pageLanguage: 'en'
                }, 'google_translate_element');
            }
        </script>
        <script src="jquery-3.7.0.min.js" integrity="sha256-2Pmvv0kuTBOenSvLm6bvfBSSHrUJ+3A7x6P5Ebd07/g=" crossorigin="anonymous"></script>
    <script>
        $('#username').on('keypress', function(e) {
            return e.which !== 32;
        });
    </script>
    <script>
    $(document).ready(function () {
        // TODO: Parse the query string to get the status and message parameters
        var urlParams = new URLSearchParams(window.location.search);
        var status = urlParams.get('status');
        var message = urlParams.get('message');

        // Check if status and message parameters are present
        if (status && message) {
            // Show SweetAlert based on the status
            if (status === 'success') {
                Swal.fire({
                    icon: 'success',
                    title: 'Success!',
                    text: message,
                });
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Error!',
                    text: message,
                });
            }
        }
    });
</script>
</body>

</html>
