<?php
session_start();
include_once("../_db.php");
$directory = '../category/';


if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Get user input
    $bedcategory = $_POST['bedcategory'];

    // Validate user input (Add more validation if necessary)
    if (empty($bedcategory)) {
        header('Location: manage-beds-category.php?status=error&message=Enter all fields');
        exit();
    }
    

    // Perform database query to insert category data (use prepared statements for security)
    $insertQuery = "INSERT INTO beds_category (bedroom_category) VALUES (?)";
    $insertStmt = $conn->prepare($insertQuery);

    if ($insertStmt) {
        $insertStmt->bind_param("s",$bedcategory);
        $insertStmt->execute();

        // Check for errors in the insertion query
        if ($insertStmt->error) {
            header('Location: manage-beds-category.php?status=error&message=Error in database query: ' . $insertStmt->error);
            exit();
        }

        $insertStmt->close();
        header('Location: manage-beds-category.php?status=success&message=category added successfully');
        exit();
    } else {
        header('Location: manage-beds-category.php?status=error&message=Error in database query: ' . $conn->error);
        exit();
    }
} else {
    header('Location: manage-beds-category.php?status=error&message=Invalid request');
    exit();
}

// Close the database connection
$conn->close();
?>
