<?php
session_start();
include_once("../_db.php");
$directory = '../category/';


if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Get user input
    $category = $_POST['category'];
    $category_image = $_FILES['category_image'];

    // Validate user input (Add more validation if necessary)
    if (empty($category) || empty($category_image['name'])) {
        header('Location: manage-category.php?status=error&message=Enter all fields');
        exit();
    }
    // Process the file upload (You may want to add more validation and handling here)
    $category_image_name = $category_image['name'];
    $category_image_tmp = $category_image['tmp_name'];
    $upload_directory = '../category1/'; // Change this to your desired upload directory

    move_uploaded_file($category_image_tmp, $upload_directory . $category_image_name);

    // Perform database query to insert category data (use prepared statements for security)
    $insertQuery = "INSERT INTO category (category, category_image) VALUES (?, ?)";
    $insertStmt = $conn->prepare($insertQuery);

    if ($insertStmt) {
        $insertStmt->bind_param("ss",$category, $category_image_name);
        $insertStmt->execute();

        // Check for errors in the insertion query
        if ($insertStmt->error) {
            header('Location: manage-category.php?status=error&message=Error in database query: ' . $insertStmt->error);
            exit();
        }

        $insertStmt->close();
        header('Location: manage-category.php?status=success&message=category added successfully');
        exit();
    } else {
        header('Location: manage-category.php?status=error&message=Error in database query: ' . $conn->error);
        exit();
    }
} else {
    header('Location: manage-category.php?status=error&message=Invalid request');
    exit();
}

// Close the database connection
$conn->close();
?>
