<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
include 'head.php';
include 'header.php';
?>

<body class="skin-default fixed-layout">
<div id="main-wrapper">
    <?php include 'sidebar.php'; ?>

    <div class="page-wrapper">
        <div class="container-fluid">
            <?php include 'nav.php'; ?>

            <!-- Success Message -->
            <?php if (isset($_SESSION['mgs'])) { echo $_SESSION['mgs']; unset($_SESSION['mgs']); } ?>

            <!-- Add Program Button -->
            <div class="container text-right my-3">
                <button type="button" class="btn btn-primary text-white" data-toggle="modal" data-target="#addProgramModal">
                    <i class="bi bi-plus"></i> Add New Program
                </button>
            </div>

            <!-- Add Program Modal -->
            <div class="modal fade" id="addProgramModal">
                <div class="modal-dialog">
                    <div class="modal-content">

                        <div class="modal-header">
                            <h4 class="modal-title">Add New Program</h4>
                            <button type="button" class="close" data-dismiss="modal">&times;</button>
                        </div>

                        <form action="program_controller.php" method="POST">
                            <div class="modal-body">
                                <div class="form-group">
                                    <label>Program Name</label>
                                    <input type="text" name="program_name" class="form-control" required>
                                </div>

                                <div class="form-group">
                                    <label>Minimum Amount ($)</label>
                                    <input type="number" step="0.01" name="min_amount" class="form-control" required>
                                </div>

                                <div class="form-group">
                                    <label>Maximum Amount ($)</label>
                                    <input type="number" step="0.01" name="max_amount" class="form-control" required>
                                </div>

                                <div class="form-group">
                                    <label>ROI (%)</label>
                                    <input type="number" step="0.1" name="roi" class="form-control" required>
                                </div>

                                <div class="form-group">
                                    <label>Duration (Days)</label>
                                    <input type="number" name="duration_days" class="form-control" required>
                                </div>

                                <div class="form-group">
                                    <label>Status</label>
                                    <select name="status" class="form-control" required>
                                        <option value="active">Active</option>
                                        <option value="inactive">Inactive</option>
                                    </select>
                                </div>
                            </div>

                            <div class="modal-footer">
                                <button type="submit" name="btnAddProgram" class="btn btn-success">Save Program</button>
                                <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                            </div>
                        </form>

                    </div>
                </div>
            </div>

            <!-- Display All Programs -->
            <div class="container card">
                <div class="card-header bg-dark text-white">
                    <h4 class="card-title">📊 All Investment Programs</h4>
                </div>

                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered align-middle">
                            <thead class="table-light">
                                <tr>
                                    <th>#</th>
                                    <th>Program Name</th>
                                    <th>Min ($)</th>
                                    <th>Max ($)</th>
                                    <th>ROI (%)</th>
                                    <th>Days</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                            <?php
                            $result = $conn->query("SELECT * FROM programs ORDER BY id ASC");
                            if ($result && $result->num_rows > 0) {
                                $num = 1;
                                while ($row = $result->fetch_assoc()) {
                                    ?>
                                    <tr>
                                        <td><?= $num++; ?></td>
                                        <td><?= htmlspecialchars($row['program_name']); ?></td>
                                        <td>$<?= number_format($row['min_amount'], 2); ?></td>
                                        <td>$<?= number_format($row['max_amount'], 2); ?></td>
                                        <td><?= $row['roi']; ?>%</td>
                                        <td><?= $row['duration_days']; ?></td>
                                        <td>
                                            <span class="badge bg-<?= $row['status'] == 'active' ? 'success' : 'secondary'; ?>">
                                                <?= ucfirst($row['status']); ?>
                                            </span>
                                        </td>
                                        <td>
                                            <a href="edit_program.php?id=<?= $row['id']; ?>" class="btn btn-info btn-sm">Edit</a>
                                            <a href="program_controller.php?delete=<?= $row['id']; ?>" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure you want to delete this program?');">Delete</a>
                                        </td>
                                    </tr>
                                <?php
                                }
                            } else {
                                echo "<tr><td colspan='8' class='text-center text-muted'>No programs found.</td></tr>";
                            }
                            ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

        </div> <!-- container -->
    </div> <!-- page-wrapper -->
</div> <!-- main-wrapper -->

<?php include 'footer.php'; ?>
</body>
</html>
