<?php
include "./include/head.php";
include "./include/navbar.php";
include "sidebar.php";

if (!isset($_SESSION['userid'])) {
    header("Location: login.php");
    exit();
}

$userid = $_SESSION['userid'];
$product_id = $_GET['product_id'] ?? '';

if (empty($product_id)) {
    echo "<div class='container py-5'><div class='alert alert-danger'>No product selected for promotion.</div></div>";
    include "footer.php";
    exit();
}

// Fetch the selected product (only allow products not created by users)
$stmt = $conn->prepare("SELECT * FROM products WHERE product_id = ?");
$stmt->bind_param("s", $product_id);
$stmt->execute();
$product = $stmt->get_result()->fetch_assoc();

if (!$product) {
    echo "<div class='container py-5'><div class='alert alert-warning'>Product not found or not eligible for promotion.</div></div>";
    include "footer.php";
    exit();
}

$promotion_fee = floatval($product['amount']);

// Fetch all wallet/payment methods
$wallets_result = $conn->query("SELECT * FROM wallet ORDER BY id ASC");
$wallets = [];
while ($row = $wallets_result->fetch_assoc()) {
    $wallets[$row['wallet_type']] = $row['wallet_address'];
}
?>

<!-- Bootstrap + FontAwesome -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">

<!-- Styles -->
<style>
    body {
        background: #f4f6fa;
    }

    .promo-card {
        border-radius: 20px;
        border: none;
        box-shadow: 0 12px 24px rgba(0, 0, 0, 0.08);
        overflow: hidden;
        transition: all 0.3s ease;
    }

    .promo-card:hover {
        transform: translateY(-5px);
    }

    .promo-card img {
        height: 250px;
        object-fit: cover;
    }

    .form-label {
        font-weight: 600;
    }

    .wallet-box {
        background: #f1f5f9;
        padding: 0.75rem 1rem;
        border-radius: 12px;
        font-size: 0.95rem;
        font-weight: 500;
    }

    .btn-submit {
        background: linear-gradient(135deg, #667eea, #764ba2);
        color: white;
        font-weight: 600;
        border-radius: 50px;
        padding: 0.75rem;
        font-size: 1.05rem;
        transition: all 0.3s ease-in-out;
    }

    .btn-submit:hover {
        opacity: 0.95;
    }

    .section-title {
        font-weight: 700;
        font-size: 1.5rem;
    }
</style>

<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-lg-8">
            <div class="card promo-card">

                <?php if (isset($_SESSION['flash_message'])): ?>
                    <?php $msg = $_SESSION['flash_message']; ?>
                    <div class="alert alert-<?= $msg['type'] ?> alert-dismissible fade show m-3" role="alert">
                        <?= $msg['text'] ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    <?php unset($_SESSION['flash_message']); ?>
                <?php endif; ?>

                <img src="./uploads/<?= htmlspecialchars($product['image']) ?>" class="card-img-top" alt="Product Image">

                <div class="card-body">
                    <h4 class="section-title mb-2">
                        <i class="fas fa-bullhorn text-primary me-1"></i>
                        <?= htmlspecialchars($product['product_name']) ?>
                    </h4>
                    <p class="text-muted"><?= nl2br(htmlspecialchars($product['description'])) ?></p>

                    <ul class="list-unstyled small mb-4">
                        <li><i class="fas fa-money-bill-wave me-2 text-success"></i> Amount: $<?= number_format($product['amount']) ?></li>
                    </ul>

                    <hr class="my-3">
                    <h5 class="text-danger fw-bold mb-3">
                        <i class="fas fa-wallet me-2"></i>Promotion Fee: $<?= number_format($promotion_fee, 2) ?>
                    </h5>

                    <!-- Promotion Form -->
                    <form action="process_promotion.php" method="POST" enctype="multipart/form-data">
                        <input type="hidden" name="product_id" value="<?= htmlspecialchars($product['product_id']) ?>">
                        <input type="hidden" name="promotion_fee" value="<?= htmlspecialchars($promotion_fee) ?>">

                        <!-- Wallet Type -->
                        <div class="mb-3">
                            <label for="payment_method" class="form-label">Select Payment Method</label>
                            <select class="form-select" id="payment_method" name="payment_method" required onchange="showWallet(this.value)">
                                <option value="">-- Choose Method --</option>
                                <?php foreach ($wallets as $type => $address): ?>
                                    <option value="<?= htmlspecialchars($type) ?>"><?= strtoupper($type) ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>

                        <!-- Wallet Address -->
                        <div class="mb-3" id="wallet_section" style="display:none;">
                            <label class="form-label">Wallet / Account Address</label>
                            <div class="wallet-box d-flex justify-content-between align-items-center">
                                <span id="wallet_address">Loading...</span>
                                <button type="button" class="btn btn-sm btn-outline-dark" onclick="copyWallet()">
                                    <i class="fas fa-copy"></i>
                                </button>
                            </div>
                        </div>

                        <!-- Proof Upload -->
                        <div class="mb-3">
                            <label for="payment_proof" class="form-label">Upload Payment Proof</label>
                            <input type="file" class="form-control" name="payment_proof" id="payment_proof" accept="image/*,.pdf" required>
                            <div class="form-text">Accepted: image or PDF (Max 2MB)</div>
                        </div>

                        <button type="submit" class="btn btn-submit w-100 mt-3">
                            <i class="fas fa-paper-plane me-2"></i> Submit to Promote Product
                        </button>
                    </form>
                </div>
            </div>

            <div class="text-center mt-4">
                <a href="promote_projects.php" class="text-decoration-none text-muted small">
                    <i class="fas fa-arrow-left me-1"></i> Back to Products
                </a>
            </div>
        </div>
    </div>
</div>

<!-- JS -->
<script>
    const wallets = <?= json_encode($wallets) ?>;

    function showWallet(method) {
        const walletDisplay = document.getElementById("wallet_address");
        const walletSection = document.getElementById("wallet_section");

        if (wallets[method]) {
            walletDisplay.textContent = wallets[method];
            walletSection.style.display = "block";
        } else {
            walletDisplay.textContent = "";
            walletSection.style.display = "none";
        }
    }

    function copyWallet() {
        const address = document.getElementById("wallet_address").textContent;
        navigator.clipboard.writeText(address)
            .then(() => alert("✅ Wallet address copied!"))
            .catch(err => alert("❌ Copy failed."));
    }
</script>

<?php include "footer.php"; ?>
