<?php 
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include "./include/head.php";
include "sidebar.php";
include "./include/navbar.php";

if (!isset($_SESSION['userid'])) {
    header("Location: login.php");
    exit();
}

$success = $error = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $userid = $_SESSION['userid'];
    $amount = floatval($_POST['amount']);
    $method = $_POST['withdraw_method'];

    if ($amount >= 5 && $method) { // minimum withdrawal: 5 USD
        // Get user balance
        $balResult = mysqli_query($conn, "SELECT account_balance FROM user_login WHERE userid = '$userid'");
        $userRow = mysqli_fetch_assoc($balResult);
        $current_balance = floatval($userRow['account_balance']);

        if ($current_balance < $amount) {
            $error = "❌ Insufficient balance.";
        } else {
            if ($method === 'wallet') {
                $wallet_type = mysqli_real_escape_string($conn, $_POST['wallet_type']);
                $wallet_address = mysqli_real_escape_string($conn, $_POST['wallet_address']);

                if ($wallet_type && $wallet_address) {
                    $stmt = $conn->prepare("INSERT INTO withdrawals (userid, amount, method, wallet_type, wallet_address, status, created_at)
                                            VALUES (?, ?, 'wallet', ?, ?, 'pending', NOW())");
                    $stmt->bind_param("sdss", $userid, $amount, $wallet_type, $wallet_address);
                } else {
                    $error = "❌ Wallet type and address are required.";
                }
            } elseif ($method === 'bank') {
                $bank_name = mysqli_real_escape_string($conn, $_POST['bank_name']);
                $account_name = mysqli_real_escape_string($conn, $_POST['account_name']);
                $account_number = mysqli_real_escape_string($conn, $_POST['account_number']);

                if ($bank_name && $account_name && $account_number) {
                    $stmt = $conn->prepare("INSERT INTO withdrawals (userid, amount, method, bank_name, account_name, account_number, status, created_at)
                                            VALUES (?, ?, 'bank', ?, ?, ?, 'pending', NOW())");
                    $stmt->bind_param("sdsss", $userid, $amount, $bank_name, $account_name, $account_number);
                } else {
                    $error = "❌ Bank details are required.";
                }
            }

            if (isset($stmt)) {
                if ($stmt->execute()) {
                    // Do NOT deduct balance yet; admin approves first
                    $success = "✅ Withdrawal request submitted successfully. We will review your request.";
                } else {
                    $error = "❌ Failed to submit request.";
                }
                $stmt->close();
            }
        }
    } else {
        $error = "❌ Invalid amount or method. Minimum withdrawal is $5.";
    }
}
?>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
    body { background: #f4f6fa; }
    .withdrawal-card { background: #fff; border-radius: 20px; box-shadow: 0 10px 25px rgba(0,0,0,0.08); padding: 2rem; }
    .btn-gradient { background: linear-gradient(135deg, #667eea, #764ba2); color: white; font-weight: 600; transition: 0.3s; }
    .btn-gradient:hover { filter: brightness(1.1); transform: scale(1.02); }
    .form-control { border-radius: 50px; padding: 0.75rem 1.25rem; }
    label { font-weight: 600; }
</style>

<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-lg-7">
            <div class="text-center mb-5">
                <h2 class="fw-bold text-dark">💸 Withdraw Funds</h2>
                <p class="text-muted">Fill in your account details to request a withdrawal. Admin will review your request.</p>
            </div>

            <?php if ($success) : ?>
                <div class="alert alert-success text-center"><?php echo $success; ?></div>
            <?php elseif ($error) : ?>
                <div class="alert alert-danger text-center"><?php echo $error; ?></div>
            <?php endif; ?>

            <div class="withdrawal-card">
                <form method="POST" class="row g-4" id="withdrawalForm">
                    <div class="col-12">
                        <label class="form-label">Withdrawal Amount (USD)</label>
                        <input type="number" name="amount" step="0.01" min="5" class="form-control" required placeholder="e.g. 150.00">
                    </div>

                    <div class="col-12">
                        <label class="form-label">Withdraw To</label>
                        <select name="withdraw_method" id="withdraw_method" class="form-control" onchange="toggleMethod()" required>
                            <option value="" disabled selected>Select method</option>
                            <option value="bank">Bank Account</option>
                            <option value="wallet">Crypto Wallet</option>
                        </select>
                    </div>

                    <!-- Bank Fields -->
                    <div id="bank_fields" class="row g-3" style="display: none;">
                        <div class="col-md-6">
                            <label class="form-label">Bank Name</label>
                            <input type="text" name="bank_name" class="form-control" placeholder="e.g. Bank of America">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Account Name</label>
                            <input type="text" name="account_name" class="form-control" placeholder="e.g. John Doe">
                        </div>
                        <div class="col-12">
                            <label class="form-label">Account Number</label>
                            <input type="text" name="account_number" class="form-control" placeholder="e.g. 0123456789">
                        </div>
                    </div>

                    <!-- Wallet Fields -->
                    <div id="wallet_fields" class="row g-3" style="display: none;">
                        <div class="col-md-6">
                            <label class="form-label">Wallet Type</label>
                            <select name="wallet_type" class="form-control">
                                <option value="">Select wallet</option>
                                <option value="Bitcoin">Bitcoin</option>
                                <option value="Ethereum">Ethereum</option>
                                <option value="USDT (TRC20)">USDT (TRC20)</option>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Wallet Address</label>
                            <input type="text" name="wallet_address" class="form-control" placeholder="Paste your wallet address">
                        </div>
                    </div>

                    <div class="col-12 text-center">
                        <button type="submit" class="btn btn-lg btn-gradient rounded-pill px-5">
                            <i class="fas fa-check-circle me-2"></i>Request Withdrawal
                        </button>
                    </div>
                </form>
            </div>

            <div class="text-center mt-4">
                <a href="dashboard.php" class="text-muted text-decoration-none small">
                    <i class="fas fa-arrow-left me-1"></i> Back to Dashboard
                </a>
            </div>
        </div>
    </div>
</div>

<script>
    function toggleMethod() {
        const method = document.getElementById("withdraw_method").value;
        document.getElementById("bank_fields").style.display = method === "bank" ? "flex" : "none";
        document.getElementById("wallet_fields").style.display = method === "wallet" ? "flex" : "none";
    }
</script>

<?php include "footer.php"; ?>
